/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.selfmonitor.SelfMonitorMetrics;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.concurrent.atomic.AtomicInteger;

public enum TraceSpanLimiter {
    INSTANCE;

    private static final ContextKey<AtomicInteger> SPAN_COUNTER_KEY;
    private volatile int spanCountThresholdPerTrace = 10000;

    public Context initIfAbsent(Context context) {
        if (context.get(SPAN_COUNTER_KEY) == null) {
            return context.with(SPAN_COUNTER_KEY, new AtomicInteger());
        }
        return context;
    }

    public boolean exceedSpanLimit(Context context) {
        boolean exceeded;
        AtomicInteger integer = context.get(SPAN_COUNTER_KEY);
        if (integer == null) {
            return false;
        }
        if (integer.get() > this.spanCountThresholdPerTrace) {
            SelfMonitorMetrics.increaseLimitedSpanCount("exceed-per-trace-span-limit");
            return true;
        }
        boolean bl = exceeded = integer.incrementAndGet() > this.spanCountThresholdPerTrace;
        if (exceeded) {
            SelfMonitorMetrics.increaseLimitedSpanCount("exceed-per-trace-span-limit");
        }
        return exceeded;
    }

    public void setSpanCountThresholdPerTrace(int spanCountThresholdPerTrace) {
        this.spanCountThresholdPerTrace = spanCountThresholdPerTrace;
    }

    static {
        SPAN_COUNTER_KEY = ContextKey.named("span_counter");
    }
}

