/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanReader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.AgentInfoHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapSetter;

final class PropagatingToDownstreamInstrumenter<REQUEST, RESPONSE>
extends Instrumenter<REQUEST, RESPONSE> {
    private final ContextPropagators propagators;
    private final TextMapSetter<REQUEST> setter;
    private final SpanReader spanReader;

    PropagatingToDownstreamInstrumenter(InstrumenterBuilder<REQUEST, RESPONSE> builder, TextMapSetter<REQUEST> setter) {
        super(builder);
        this.propagators = builder.openTelemetry.getPropagators();
        this.setter = setter;
        this.spanReader = GlobalInstanceHolder.getInstance(SpanReader.class);
    }

    @Override
    public Context start(Context parentContext, REQUEST request) {
        parentContext = this.injectPRpcAndPPid(parentContext);
        Context newContext = super.start(parentContext, request);
        this.propagators.getTextMapPropagator().inject(newContext, request, this.setter);
        return newContext;
    }

    private Context injectPRpcAndPPid(Context newContext) {
        String rpc;
        Span span = LocalRootSpan.fromContext(newContext);
        BaggageBuilder builder = Baggage.fromContext(newContext).toBuilder().put("EagleEye-pAppName", AgentInfoHolder.armsAppId);
        if (span != null && this.spanReader != null && (rpc = this.spanReader.readSpanName(span)) != null) {
            builder.put("EagleEye-pRpc", rpc);
        }
        return builder.build().storeInContext(newContext);
    }
}

