/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.com.alibaba.arms.metrics.spec.UniCallKind;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.InstrumenterEntranceTrigger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.RpcIdGenerator;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanCompressor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanReader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.sample.LocalTailSampler;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.AliyunContextHolderUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.BaggageUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.SpanUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.selfmonitor.SampleInfoHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.selfmonitor.SelfMonitorMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.BusinessObservabilityService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.extract.CustomParamExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsProperties;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsThreadFactory;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.SkywalkingContext;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.SkywalkingSpanBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.convergence.ConvergeService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.degradation.ArmsDataDegradationStateAdapter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsRpcTypeEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.flowcontrol.SimpleTokenBucket;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.profiling.HotSpotRecorder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.resource.GlobalResourceLimiterState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.resource.ResourceLimitStateEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.resource.SimplifiedResourceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.tag.TagService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.CompositeAttributesBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.MetricsRecorder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanLinksBuilderImpl;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanStatusBuilderImpl;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanSuppressor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.TraceSpanLimiter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.UnsafeAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsChildSpanAttribute;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsChildSpanContext;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsCustomSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsResourceRecorder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsSpanCompressUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.InstrumenterAccess;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.InstrumenterUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SupportabilityMetrics;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class Instrumenter<REQUEST, RESPONSE> {
    private static volatile boolean flag = false;
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private final String instrumentationName;
    private final Tracer tracer;
    private final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    private final SpanKindExtractor<? super REQUEST> spanKindExtractor;
    private final SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor;
    private final List<? extends SpanLinksExtractor<? super REQUEST>> spanLinksExtractors;
    private final List<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors;
    private final List<? extends CustomParamExtractor<? super REQUEST, ? super RESPONSE>> customParamExtractors;
    private final List<? extends ContextCustomizer<? super REQUEST>> contextCustomizers;
    private final List<? extends OperationListener> operationListeners;
    private final ErrorCauseExtractor errorCauseExtractor;
    private final boolean enabled;
    private final SpanSuppressor spanSuppressor;
    private final Attributes selfMonitorAttribute;
    private SpanCompressor spanCompressor;
    private final InstrumenterEntranceTrigger instrumenterEntranceTrigger;
    private final TagService tagService;
    private final ConvergeService convergeService;
    private SpanReader spanReader;
    private ArmsResourceRecorder armsResourceRecorder;
    private LocalTailSampler tailSampler;
    private final BusinessObservabilityService bizO11yService;
    private GlobalResourceLimiterState globalResourceLimiterState;
    private static final PatchLogger logger = PatchLogger.getLogger(Instrumenter.class.getName());
    UniCallKind uniCallKind;

    public static <REQUEST, RESPONSE> InstrumenterBuilder<REQUEST, RESPONSE> builder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        return new InstrumenterBuilder(openTelemetry, instrumentationName, spanNameExtractor);
    }

    Instrumenter(InstrumenterBuilder<REQUEST, RESPONSE> builder) {
        this.instrumentationName = builder.instrumentationName;
        this.selfMonitorAttribute = Attributes.of(AttributeKey.stringKey("instrumentation_name"), this.instrumentationName);
        this.tracer = builder.buildTracer();
        this.spanNameExtractor = builder.spanNameExtractor;
        this.spanKindExtractor = builder.spanKindExtractor;
        this.spanStatusExtractor = builder.spanStatusExtractor;
        this.spanLinksExtractors = new ArrayList(builder.spanLinksExtractors);
        this.attributesExtractors = new ArrayList(builder.attributesExtractors);
        this.contextCustomizers = new ArrayList(builder.contextCustomizers);
        this.operationListeners = builder.buildOperationListeners();
        this.errorCauseExtractor = builder.errorCauseExtractor;
        this.enabled = builder.enabled;
        this.spanSuppressor = builder.buildSpanSuppressor();
        this.spanCompressor = GlobalInstanceHolder.getInstance(SpanCompressor.class);
        this.instrumenterEntranceTrigger = GlobalInstanceHolder.getInstance(InstrumenterEntranceTrigger.class);
        this.tagService = GlobalInstanceHolder.getInstance(TagService.class);
        this.convergeService = GlobalInstanceHolder.getInstance(ConvergeService.class);
        this.spanReader = GlobalInstanceHolder.getInstance(SpanReader.class);
        this.tailSampler = GlobalInstanceHolder.getInstance(LocalTailSampler.class);
        this.customParamExtractors = new ArrayList(builder.customParamExtractors);
        this.bizO11yService = GlobalInstanceHolder.getInstance(BusinessObservabilityService.class);
        this.armsResourceRecorder = GlobalInstanceHolder.getInstance(ArmsResourceRecorder.class);
        this.globalResourceLimiterState = GlobalInstanceHolder.getInstance(GlobalResourceLimiterState.class);
    }

    public boolean shouldStart(Context parentContext, REQUEST request) {
        if (this.instrumenterEntranceTrigger != null && !this.instrumenterEntranceTrigger.isInstrumenterEntranceEnable()) {
            return false;
        }
        if (!this.enabled || Instrumenter.shouldSkip()) {
            return false;
        }
        if (!SimpleTokenBucket.INSTANCE.canPass()) {
            SelfMonitorMetrics.increaseFlowControlLimit();
            return false;
        }
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        if (!ArmsDataDegradationStateAdapter.INSTANCE.isEnableEntrancelesSpanAndMetrics() && this.isEntrancelessInternalOrClientInstrumenter(parentContext, spanKind)) {
            return false;
        }
        boolean suppressed = this.spanSuppressor.shouldSuppress(parentContext, spanKind);
        if (suppressed) {
            supportability.recordSuppressedSpan(spanKind, this.instrumentationName);
        }
        return !suppressed;
    }

    private boolean isEntrancelessInternalOrClientInstrumenter(Context parentContext, SpanKind spanKind) {
        boolean isLocalRoot = LocalRootSpan.isLocalRoot(parentContext);
        if (!isLocalRoot) {
            return false;
        }
        if (spanKind == SpanKind.CLIENT || spanKind == SpanKind.PRODUCER) {
            return true;
        }
        if (spanKind == SpanKind.INTERNAL) {
            if (this.uniCallKind == null) {
                return false;
            }
            return this.uniCallKind != UniCallKind.SCHEDULE && this.uniCallKind != UniCallKind.CUSTOM_ENTRY;
        }
        return false;
    }

    public Context start(Context parentContext, REQUEST request) {
        try {
            return this.doStart(parentContext, request, null);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "[Instrumenter] start fail", e);
            return parentContext;
        }
    }

    public void end(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        try {
            this.doEnd(context, request, response, error, null);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "[Instrumenter] end fail", e);
        }
    }

    Context startAndEnd(Context parentContext, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error, Instant startTime, Instant endTime) {
        Context context = this.doStart(parentContext, request, startTime);
        this.doEnd(context, request, response, error, endTime);
        return context;
    }

    /*
     * WARNING - void declaration
     */
    private Context doStart(Context parentContext, REQUEST request, @Nullable Instant startTime) {
        void var14_35;
        void var14_29;
        void var14_25;
        boolean spanCompressEnable;
        long startTimeToNanos;
        boolean selfMonitorSampled;
        Context limitedContext = this.doLimit(parentContext);
        if (limitedContext != null) {
            return limitedContext;
        }
        long startThreadCpuTime = -1L;
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.spanNameExtractor.extract(request)).setSpanKind(spanKind);
        if (startTime != null) {
            spanBuilder.setStartTimestamp(startTime);
        }
        if (selfMonitorSampled = this.shouldSampleSelfMonitor(startTimeToNanos = Instrumenter.getStartNanos())) {
            if (this.armsResourceRecorder != null) {
                startThreadCpuTime = this.armsResourceRecorder.getCurrentThreadCpuTime();
            }
            SelfMonitorMetrics.increaseInstrumenterStartExecutedCount(this.selfMonitorAttribute);
        }
        SpanLinksBuilderImpl spanLinksBuilder = new SpanLinksBuilderImpl(spanBuilder);
        for (SpanLinksExtractor<REQUEST> spanLinksExtractor : this.spanLinksExtractors) {
            spanLinksExtractor.extract(spanLinksBuilder, parentContext, request);
        }
        CompositeAttributesBuilder attributesBuilder = new CompositeAttributesBuilder();
        for (AttributesExtractor<REQUEST, RESPONSE> attributesExtractor : this.attributesExtractors) {
            attributesExtractor.onStart(attributesBuilder, parentContext, request);
        }
        Context context4 = parentContext;
        context4 = context4.with(ArmsConstants.ContextKeys.ALL_EXCEPTION_IDS_KEY, new StringBuffer());
        context4 = AliyunContextHolderUtils.attachAliyunConyextHolderIfAbsent(context4);
        context4 = RpcIdGenerator.increaseRpcId4CurrentSpan(context4);
        Attributes attributes = attributesBuilder.build();
        boolean localRoot = LocalRootSpan.isLocalRoot(context4);
        boolean bl = spanCompressEnable = this.spanCompressor != null && this.spanCompressor.isSpanCompressEnable();
        if (spanCompressEnable) {
            void var14_21;
            long startNanoTime = this.getStartNanoTimeFromRootSpan(context4);
            if (startTime != null) {
                startNanoTime = TimeUnit.SECONDS.toNanos(startTime.getEpochSecond()) + (long)startTime.getNano();
            }
            if (localRoot) {
                Context context5 = context4.with(ArmsChildSpanContext.ROOT_SPAN_START_NANO_TIME, startNanoTime);
            }
            spanBuilder.setStartTimestamp(startNanoTime, TimeUnit.NANOSECONDS);
            List<ArmsCustomSpan> parentChildSpanList = parentContext.get(ArmsChildSpanContext.CHILD_SPAN_CONTEXT_KEY);
            if (parentChildSpanList != null) {
                void var14_19;
                Context context6 = var14_19.with(ArmsChildSpanContext.PARENT_CHILD_SPAN_CONTEXT_KEY, parentChildSpanList);
            }
            Context context8 = var14_21.with(ArmsChildSpanContext.CHILD_SPAN_CONTEXT_KEY, new ArrayList());
            context8 = context8.with(ArmsChildSpanContext.SPAN_START_NANO_TIME_CONTEXT_KEY, startNanoTime);
        }
        for (ContextCustomizer<REQUEST> contextCustomizer : this.contextCustomizers) {
            Context context9 = contextCustomizer.onStart((Context)var14_25, request, attributes);
        }
        spanBuilder.setAllAttributes(attributes);
        Span span = spanBuilder.setParent((Context)var14_25).startSpan();
        Context context10 = this.handleSkywalkingContext((Context)var14_25, span);
        if (spanKind == SpanKind.INTERNAL) {
            SpanUtils.updateResource(span, SimplifiedResourceHolder.getSimplifiedResource());
            span.setAttribute(ArmsConstants.AttributeKeys.LOCAL_ROOT_SPAN_ID, LocalRootSpan.fromContext(context10).getSpanContext().getSpanId());
        }
        Context context11 = context10.with(span);
        if (localRoot && span.getSpanContext().isSampled()) {
            Baggage baggage = Baggage.fromContext(context11);
            String sampleService = baggage.getEntryValue(ArmsConstants.AttributeKeys.SAMPLE_SERVICE_KEY.getKey());
            String sampleFlagIncomer = baggage.getEntryValue(ArmsConstants.AttributeKeys.SAMPLE_FLAG_INCOMER_KEY.getKey());
            if (StringUtils.isNullOrEmpty(sampleService) && StringUtils.isNullOrEmpty(sampleFlagIncomer)) {
                String clientAddr = attributes.get(ArmsConstants.AttributeKeys.CLIENT_ADDRESS);
                if (StringUtils.isNullOrEmpty(clientAddr)) {
                    clientAddr = "unknownSampleFlagIncomer";
                }
                BaggageUtil.putBaggageDirectly(ArmsConstants.AttributeKeys.SAMPLE_FLAG_INCOMER_KEY.getKey(), clientAddr, context11);
                span.setAttribute(ArmsConstants.AttributeKeys.SAMPLE_FLAG_INCOMER_KEY, clientAddr);
            }
        }
        Long rpcTypeIndex = attributes.get(ArmsConstants.AttributeKeys.RPC_TYPE_ENUM_INDEX_KEY);
        ArmsRpcTypeEnum armsRpcTypeEnum = ArmsRpcTypeEnum.getByIndex(rpcTypeIndex);
        if (this.uniCallKind == null || this.uniCallKind != armsRpcTypeEnum.getUniCallKind()) {
            this.uniCallKind = armsRpcTypeEnum.getUniCallKind();
        }
        if (!this.operationListeners.isEmpty()) {
            long startNanos = Instrumenter.getNanos(startTime);
            for (OperationListener operationListener : this.operationListeners) {
                Context context12 = operationListener.onStart((Context)var14_29, Attributes.empty(), startNanos);
            }
        }
        if (localRoot) {
            Context context15 = LocalRootSpan.store((Context)var14_29, span);
            context15 = this.initSampleInfo(parentContext, context15);
            context15 = TraceSpanLimiter.INSTANCE.initIfAbsent(context15);
        } else {
            Context context16 = this.removeSampleInfoInNonLocalRootSpan((Context)var14_29);
        }
        Context context17 = this.bizO11yHandleOnStart((Context)var14_35, request, span);
        if (!spanCompressEnable && span.getSpanContext().isSampled() && TraceSpanLimiter.INSTANCE.exceedSpanLimit(context17)) {
            SpanUtils.updateSampleFlag(span, TraceFlags.getDefault());
        }
        if (selfMonitorSampled) {
            Long totalRT = System.nanoTime() - startTimeToNanos;
            SelfMonitorMetrics.increaseInstrumenterStartResponseTime(this.selfMonitorAttribute, totalRT);
            if (this.armsResourceRecorder != null) {
                this.armsResourceRecorder.recordInstrumenterStart(context17, totalRT, this.armsResourceRecorder.getCurrentThreadCpuTime() - startThreadCpuTime, this.selfMonitorAttribute);
            }
        }
        return this.spanSuppressor.storeInContext(context17, spanKind, span);
    }

    private Context initSampleInfo(Context parentContext, Context currentContext) {
        SampleInfoHolder sampleInfoHolder = new SampleInfoHolder();
        Span parentSpan = Span.fromContext(parentContext);
        if (!parentSpan.getSpanContext().isValid()) {
            sampleInfoHolder.setUpstreamSampled(null);
        } else {
            sampleInfoHolder.setUpstreamSampled(parentSpan.getSpanContext().isSampled());
        }
        return currentContext.with(SampleInfoHolder.SAMPLE_INFO_HOLDER_KEY, sampleInfoHolder);
    }

    private Context removeSampleInfoInNonLocalRootSpan(Context context) {
        return context.with(SampleInfoHolder.SAMPLE_INFO_HOLDER_KEY, SampleInfoHolder.INVALID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEnd(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error, @Nullable Instant endTime) {
        if (this.checkLimited(context)) {
            return;
        }
        long endRTNano = Instrumenter.getNanos(endTime);
        long instrumenterEndCpuTime = -1L;
        boolean selfMonitorSampled = this.shouldSampleSelfMonitor(endRTNano);
        if (selfMonitorSampled) {
            SelfMonitorMetrics.increaseInstrumenterEndExecutedCount(this.selfMonitorAttribute);
            if (this.armsResourceRecorder != null) {
                instrumenterEndCpuTime = this.armsResourceRecorder.getCurrentThreadCpuTime();
            }
        }
        Span span = Span.fromContext(context);
        if (error != null) {
            error = this.errorCauseExtractor.extract(error);
            span.recordException(error);
            span.setStatus(StatusCode.ERROR);
        }
        if (this.bizO11yService != null) {
            this.bizO11yService.extractOnEnd(context, request, response, error, this.customParamExtractors);
        }
        CompositeAttributesBuilder attributesBuilder = new CompositeAttributesBuilder();
        for (AttributesExtractor<REQUEST, RESPONSE> extractor : this.attributesExtractors) {
            extractor.onEnd(attributesBuilder, context, request, response, error);
        }
        CompositeAttributesBuilder metricsAttributesBuilder = new CompositeAttributesBuilder();
        CompositeAttributesBuilder spanAttributesBuilder = new CompositeAttributesBuilder(32);
        CompositeAttributesBuilder recordAttributesBuilder = new CompositeAttributesBuilder(8);
        attributesBuilder.buildAttributesBuilder(metricsAttributesBuilder, spanAttributesBuilder, recordAttributesBuilder, this.convergeService, this.uniCallKind);
        this.bizO11yHandleOnEnd(context, spanAttributesBuilder, metricsAttributesBuilder, span);
        Attributes spanAttributes = spanAttributesBuilder.build();
        Attributes metricsAttributes = metricsAttributesBuilder.build();
        Attributes recordAttributes = recordAttributesBuilder.build();
        span.setAllAttributes(spanAttributes);
        if (!this.operationListeners.isEmpty()) {
            long endNanos = Instrumenter.getNanos(endTime);
            ListIterator<? extends OperationListener> i = this.operationListeners.listIterator(this.operationListeners.size());
            while (i.hasPrevious()) {
                this.doInvokeListenerOnEnd(i.previous(), context, metricsAttributes, recordAttributes, endNanos);
            }
        }
        SpanStatusBuilderImpl spanStatusBuilder = new SpanStatusBuilderImpl(span);
        this.spanStatusExtractor.extract(spanStatusBuilder, request, response, error);
        boolean spanCompressEnable = this.spanCompressor != null && this.spanCompressor.isSpanCompressEnable();
        int cachedSpanLimit = 500;
        if (this.spanCompressor != null) {
            cachedSpanLimit = this.spanCompressor.getCachedSpanLimit();
        }
        try {
            HotSpotRecorder.setWallClockAttribute(context);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Failed to set profiling info ", t);
        }
        if (spanCompressEnable) {
            List<ArmsCustomSpan> parentChildSpanList = context.get(ArmsChildSpanContext.PARENT_CHILD_SPAN_CONTEXT_KEY);
            Long startTimeNanos = context.get(ArmsChildSpanContext.SPAN_START_NANO_TIME_CONTEXT_KEY);
            int rpcType = ArmsRpcTypeEnum.LOCAL_CALL.getCode();
            Long rpcTypeObject = metricsAttributes.get(ArmsConstants.AttributeKeys.RPC_TYPE);
            if (rpcTypeObject != null) {
                rpcType = rpcTypeObject.intValue();
            }
            if (startTimeNanos == null) {
                startTimeNanos = 0L;
            }
            ArmsCustomSpan armsCustomSpan = this.createArmsCustomSpan(this.spanNameExtractor.extract(request), spanAttributes.get(ArmsConstants.AttributeKeys.RPC), rpcType, startTimeNanos, endTime, span);
            List<ArmsCustomSpan> childSpanList = context.get(ArmsChildSpanContext.CHILD_SPAN_CONTEXT_KEY);
            if (childSpanList != null) {
                armsCustomSpan.setChildArmsCustomSpanList(childSpanList);
            }
            if (parentChildSpanList != null) {
                Boolean closed = false;
                if (this.spanReader != null) {
                    Span localRootSpan;
                    Span span2 = localRootSpan = LocalRootSpan.fromContext(context);
                    synchronized (span2) {
                        closed = this.spanReader.getAttribute(localRootSpan, ArmsChildSpanAttribute.SPAN_ROOT_CLOSED_ATTR_KEY);
                        if (closed != null && closed.booleanValue()) {
                            this.endArmsRootSpan(context, armsCustomSpan, () -> TraceSpanLimiter.INSTANCE.exceedSpanLimit(context));
                        }
                    }
                }
                if (closed == null || !closed.booleanValue()) {
                    List<ArmsCustomSpan> list = parentChildSpanList;
                    synchronized (list) {
                        if (armsCustomSpan.canEnd()) {
                            this.endArmsRootSpan(context, armsCustomSpan, () -> TraceSpanLimiter.INSTANCE.exceedSpanLimit(context));
                        } else if (!ArmsSpanCompressUtil.mergeChildSpan(parentChildSpanList, armsCustomSpan)) {
                            if (parentChildSpanList.size() < cachedSpanLimit) {
                                parentChildSpanList.add(armsCustomSpan);
                            } else {
                                this.endArmsRootSpan(context, armsCustomSpan, () -> TraceSpanLimiter.INSTANCE.exceedSpanLimit(context));
                            }
                        }
                    }
                }
            } else {
                Span localRootSpan;
                Span span3 = localRootSpan = LocalRootSpan.fromContext(context);
                synchronized (span3) {
                    localRootSpan.setAttribute(ArmsChildSpanAttribute.SPAN_ROOT_CLOSED_ATTR_KEY, Boolean.valueOf(true));
                    localRootSpan.setAttribute(ArmsChildSpanAttribute.SPAN_ROOT_CLOSED_TIME_ATTR_KEY, Long.valueOf(System.nanoTime()));
                }
                this.endArmsRootSpan(context, armsCustomSpan, () -> TraceSpanLimiter.INSTANCE.exceedSpanLimit(context));
            }
        } else if (endTime != null) {
            span.end(endTime);
        } else {
            span.end();
        }
        if (selfMonitorSampled) {
            long endTotalRT = System.nanoTime() - endRTNano;
            SelfMonitorMetrics.increaseInstrumenterEndResponseTime(this.selfMonitorAttribute, endTotalRT);
            if (this.armsResourceRecorder != null) {
                this.armsResourceRecorder.recordInstrumenterEnd(context, endTotalRT, this.armsResourceRecorder.getCurrentThreadCpuTime() - instrumenterEndCpuTime, this.selfMonitorAttribute);
            }
        }
    }

    private ArmsCustomSpan createArmsCustomSpan(String name, @Nullable String rpcName, int rpcType, Long startTimeNanos, Instant endTime, Span span) {
        StatusCode statusCode = StatusCode.UNSET;
        long duration = endTime != null ? TimeUnit.SECONDS.toNanos(endTime.getEpochSecond()) + (long)endTime.getNano() - startTimeNanos : (this.spanReader != null ? this.spanReader.getLatencyNanos(span) : System.currentTimeMillis() - TimeUnit.NANOSECONDS.toMillis(startTimeNanos));
        if (this.spanReader != null) {
            statusCode = this.spanReader.readSpanStatus(span);
        }
        return ArmsCustomSpan.create(name, rpcName, rpcType, duration, startTimeNanos, statusCode, span);
    }

    private UnsafeAttributes getSpanAttributes(UnsafeAttributes attributes) {
        UnsafeAttributes spanAttributes = new UnsafeAttributes();
        attributes.forEach((BiConsumer<? super AttributeKey<?>, ? super Object>)((BiConsumer<AttributeKey, Object>)(attributeKey, o) -> {
            if (!ArmsProperties.armsSpanDiscardAttributesKeySet.contains(attributeKey.getKey())) {
                spanAttributes.put(attributeKey, o);
                if (attributeKey.getKey().equalsIgnoreCase("destId")) {
                    spanAttributes.put(ArmsConstants.AttributeKeys.OUT_ID_KEY, o);
                }
            }
        }));
        return spanAttributes;
    }

    private void endArmsRootSpan(Context context, ArmsCustomSpan armsCustomSpan, BooleanSupplier exceedSpanThreshold) {
        boolean sampleByTailSampling = false;
        if (!armsCustomSpan.getSpan().getSpanContext().isSampled() && LocalRootSpan.isLocalRoot(this.spanReader.getParentSpanContext(armsCustomSpan.getSpan()))) {
            Boolean filtered = (Boolean)AliyunContextHolderUtils.getFromAliyunContext(ArmsConstants.AttributeKeys.METRIC_SKIP_BY_RPC_KEY.getKey(), context);
            if (!(this.tailSampler == null || filtered != null && filtered.booleanValue())) {
                sampleByTailSampling = this.tailSampler.shouldSample(context, armsCustomSpan.getSpan(), armsCustomSpan.getRpcName(), armsCustomSpan.getDuration());
            }
        }
        ArmsSpanCompressUtil.endRootSpan(armsCustomSpan, sampleByTailSampling, exceedSpanThreshold);
    }

    private Context handleSkywalkingContext(Context context, Span span) {
        SkywalkingContext parentSkywalkingContext = context.get(SkywalkingContext.SKYWALKING_CONTEXT_KEY);
        if (parentSkywalkingContext != null) {
            if (span.getSpanContext().getTraceFlags().isSampled()) {
                parentSkywalkingContext.setSample("1");
            }
            SkywalkingSpanBuilder skywalkingSpanBuilder = new SkywalkingSpanBuilder(parentSkywalkingContext);
            SkywalkingContext skywalkingSpanContext = skywalkingSpanBuilder.startSpan();
            span.setAttribute("swTraceId", skywalkingSpanContext.getTraceId());
            span.setAttribute("swSpanId", (long)skywalkingSpanContext.getSpanId().intValue());
            span.setAttribute("swSegmentId", skywalkingSpanContext.getSegmentId());
            if (parentSkywalkingContext.getTraceId() != null) {
                span.setAttribute("swParentSpanId", (long)parentSkywalkingContext.getSpanId().intValue());
                span.setAttribute("swParentSegmentId", parentSkywalkingContext.getSegmentId());
            }
            return context.with(SkywalkingContext.SKYWALKING_CONTEXT_KEY, skywalkingSpanContext);
        }
        return context;
    }

    private void recordSampleInfo(Context context) {
        SampleInfoHolder holder = context.get(SampleInfoHolder.SAMPLE_INFO_HOLDER_KEY);
        if (holder != null && holder.isValid()) {
            Span span = Span.fromContext(context);
            if (holder.getUpstreamSampled() == null) {
                holder.setLocalSampled(span.getSpanContext().isSampled());
                holder.setSampleFlag(SpanUtils.getAttribute(ArmsConstants.AttributeKeys.SAMPLING_REASON_KEY, span));
            } else if (holder.getUpstreamSampled().booleanValue()) {
                holder.setLocalSampled(null);
            } else {
                holder.setLocalSampled(span.getSpanContext().isSampled());
                holder.setSampleFlag(SpanUtils.getAttribute(ArmsConstants.AttributeKeys.SAMPLING_REASON_KEY, span));
            }
            SelfMonitorMetrics.increaseSampleCount(holder);
        }
    }

    private void doInvokeListenerOnEnd(OperationListener listener, Context context, Attributes attributes, Attributes recordAttributes, long endNanos) {
        if (listener instanceof MetricsRecorder) {
            Boolean skipByRpc = (Boolean)AliyunContextHolderUtils.getFromAliyunContext(ArmsConstants.AttributeKeys.METRIC_SKIP_BY_RPC_KEY.getKey(), context);
            Boolean skipByMethod = (Boolean)AliyunContextHolderUtils.getFromAliyunContext(ArmsConstants.AttributeKeys.METRIC_SKIP_BY_HTTP_METHOD_KEY.getKey(), context);
            if (skipByRpc != null && skipByRpc.booleanValue() || skipByMethod != null && skipByMethod.booleanValue()) {
                return;
            }
            if (!recordAttributes.isEmpty()) {
                MetricsRecorder metricsRecorder = (MetricsRecorder)((Object)listener);
                metricsRecorder.recordMetrics(context, recordAttributes, attributes);
            }
        }
        listener.onEnd(context, attributes, endNanos);
    }

    private long getStartNanoTimeFromRootSpan(Context context) {
        if (context.get(ArmsChildSpanContext.ROOT_SPAN_START_NANO_TIME) != null && this.spanReader != null) {
            Long rootClosedNanoTime;
            long nanoTime = context.get(ArmsChildSpanContext.ROOT_SPAN_START_NANO_TIME);
            Span rootSpan = LocalRootSpan.fromContext(context);
            if (this.spanReader.hasEnded(rootSpan) && (rootClosedNanoTime = this.spanReader.getAttribute(rootSpan, ArmsChildSpanAttribute.SPAN_ROOT_CLOSED_TIME_ATTR_KEY)) != null) {
                return nanoTime + this.spanReader.getLatencyNanos(rootSpan) + (System.nanoTime() - rootClosedNanoTime);
            }
            return nanoTime + this.spanReader.getLatencyNanos(rootSpan);
        }
        return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    }

    private boolean shouldSampleSelfMonitor(Long startTimeToNanos) {
        return startTimeToNanos % SelfMonitorMetrics.SELF_MONITOR_SAMPLE_RATE == 0L;
    }

    private static long getNanos(@Nullable Instant time) {
        if (time == null) {
            return System.nanoTime();
        }
        return TimeUnit.SECONDS.toNanos(time.getEpochSecond()) + (long)time.getNano();
    }

    private static long getStartNanos() {
        return System.nanoTime();
    }

    private static long getStartMillisTime() {
        return System.currentTimeMillis();
    }

    public static boolean shouldSkip() {
        String groupName = Thread.currentThread().getThreadGroup().getName();
        return groupName.equals(ArmsThreadFactory.group.getName()) || groupName.equals("aliyun-mse-thread-group");
    }

    private boolean isIncomeSpan(Span span) {
        if (this.spanReader == null || span == null) {
            return false;
        }
        Long rpcType = this.spanReader.getAttribute(span, ArmsConstants.AttributeKeys.RPC_TYPE);
        return rpcType != null && ArmsRpcTypeEnum.isIncomeRpcType(rpcType.intValue());
    }

    public void setSpanCompressor(SpanCompressor spanCompressor) {
        this.spanCompressor = spanCompressor;
    }

    public void setSpanReader(SpanReader spanReader) {
        this.spanReader = spanReader;
    }

    public void setTailSampler(LocalTailSampler tailSampler) {
        this.tailSampler = tailSampler;
    }

    private Context bizO11yHandleOnStart(Context context, REQUEST request, Span span) {
        if (this.bizO11yService != null) {
            try {
                if (this.bizO11yService.isCustomExtractEnable()) {
                    context = this.bizO11yService.extractOnStart(context, request, this.customParamExtractors);
                }
                if (this.bizO11yService.isBizO11yEnable() && this.isIncomeSpan(span)) {
                    this.bizO11yService.restoreBizCodeFromBaggage(context);
                    context = this.bizO11yService.computeBizCodeWithPostProcess(context, this.spanReader);
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Unknown exception occurred on start of biz o11y handling: " + e.getMessage(), e);
            }
        }
        return context;
    }

    private void bizO11yHandleOnEnd(Context context, AttributesBuilder sab, AttributesBuilder mab, Span span) {
        if (this.bizO11yService != null) {
            try {
                boolean isIncomeSpan = this.isIncomeSpan(span);
                if (this.bizO11yService.isCustomExtractEnable()) {
                    this.bizO11yService.injectSpanAttribute(sab, context, span.getSpanContext().getSpanId(), isIncomeSpan);
                    this.bizO11yService.resetSpanStatus(span, context, sab, mab, isIncomeSpan);
                }
                if (this.bizO11yService.isBizO11yEnable()) {
                    this.bizO11yService.injectBizTraceAttributesIntoSpanAttribute(sab, context, isIncomeSpan);
                }
                this.bizO11yService.cleanupAllCache(span.getSpanContext().getSpanId(), context, isIncomeSpan);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Unknown exception occurred on end of biz o11y handling: " + e.getMessage(), e);
            }
        }
    }

    private Context doLimit(Context parentContext) {
        if (this.globalResourceLimiterState != null && this.globalResourceLimiterState.getLimitState() == ResourceLimitStateEnum.DEGRADE_STATE) {
            return parentContext.with(ArmsConstants.ContextKeys.APSARA_SELF_PROTECT, true);
        }
        if (this.globalResourceLimiterState != null && this.globalResourceLimiterState.getLimitState() == ResourceLimitStateEnum.FLOW_CONTROL_STATE) {
            Boolean selfProtect = parentContext.get(ArmsConstants.ContextKeys.APSARA_SELF_PROTECT);
            if (Boolean.TRUE.equals(selfProtect)) {
                return parentContext;
            }
            double rate = this.globalResourceLimiterState.getCoefficient();
            if (Math.random() > rate) {
                return parentContext.with(ArmsConstants.ContextKeys.APSARA_SELF_PROTECT, true);
            }
        }
        return null;
    }

    private boolean checkLimited(Context context) {
        if (this.globalResourceLimiterState != null && this.globalResourceLimiterState.getLimitState() == ResourceLimitStateEnum.DEGRADE_STATE) {
            return true;
        }
        if (this.globalResourceLimiterState != null && this.globalResourceLimiterState.getLimitState() == ResourceLimitStateEnum.FLOW_CONTROL_STATE) {
            Boolean selfProtect = context.get(ArmsConstants.ContextKeys.APSARA_SELF_PROTECT);
            return Boolean.TRUE.equals(selfProtect);
        }
        return false;
    }

    static {
        InstrumenterUtil.setInstrumenterAccess(new InstrumenterAccess(){

            public <RQ, RS> Context startAndEnd(Instrumenter<RQ, RS> instrumenter, Context parentContext, RQ request, @Nullable RS response, @Nullable Throwable error, Instant startTime, Instant endTime) {
                return instrumenter.startAndEnd(parentContext, request, response, error, startTime, endTime);
            }
        });
    }
}

