/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.com.alibaba.arms.metrics.spec.UniCallKind;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsProperties;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.convergence.ConvergeService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.degradation.ArmsDataDegradationStateAdapter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsRpcTypeEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.CompositeAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class CompositeAttributesBuilder
implements AttributesBuilder {
    private final List<Object> data;

    CompositeAttributesBuilder() {
        this.data = new ArrayList<Object>(64);
    }

    CompositeAttributesBuilder(List<Object> data) {
        this.data = data;
    }

    CompositeAttributesBuilder(int size) {
        this.data = new ArrayList<Object>(size);
    }

    @Override
    public Attributes build() {
        if (this.data.size() == 2 && this.data.get(0) != null) {
            return new CompositeAttributes(this.data.toArray());
        }
        return CompositeAttributes.toAttributes(this.data.toArray());
    }

    public void buildAttributesBuilder(CompositeAttributesBuilder metricsAttributesBuilder, CompositeAttributesBuilder spanAttributesBuilder, CompositeAttributesBuilder recordAttributesBuilder, ConvergeService convergeService, UniCallKind uniCallKind) {
        Object rpcTypeIndex = null;
        for (int i = 0; i < this.data.size(); i += 2) {
            AttributeKey key = (AttributeKey)this.data.get(i);
            if (key == null) continue;
            Object value = this.data.get(i + 1);
            this.buildConvergeAttributes(key, value, metricsAttributesBuilder, spanAttributesBuilder, recordAttributesBuilder, convergeService, uniCallKind);
        }
        if (uniCallKind != null) {
            metricsAttributesBuilder.put(ArmsConstants.AttributeKeys.ARMS_CALL_KIND_KEY, (T)uniCallKind.getName());
        }
    }

    private <K> void buildConvergeAttributes(AttributeKey<K> key, Object value, AttributesBuilder metricsAttributesBuilder, AttributesBuilder spanAttributesBuilder, AttributesBuilder recordAttributesBuilder, ConvergeService convergeService, UniCallKind uniCallKind) {
        String convergenceValue = null;
        String keyStr = key.getKey();
        int keyHashcode = key.hashCode();
        if (ArmsConstants.HashcodeKeys.DEST_ID == keyHashcode) {
            this.addAttribute(spanAttributesBuilder, value, key);
            spanAttributesBuilder.put(ArmsConstants.AttributeKeys.OUT_ID_KEY, value.toString());
            if (ArmsDataDegradationStateAdapter.INSTANCE.isEnableDestIdInMetric()) {
                if (convergeService != null && uniCallKind != UniCallKind.UNKNOWN) {
                    convergenceValue = convergeService.convergeDest(uniCallKind, value.toString());
                    this.addConvergeAttribute(metricsAttributesBuilder, spanAttributesBuilder, value, convergenceValue, key);
                } else {
                    this.addAttribute(metricsAttributesBuilder, value, key);
                }
            }
        } else if (ArmsConstants.HashcodeKeys.ENDPOINT == keyHashcode) {
            this.addAttribute(spanAttributesBuilder, value, key);
            if (ArmsDataDegradationStateAdapter.INSTANCE.isEnableEndpointInMetric()) {
                if (convergeService != null && uniCallKind != UniCallKind.UNKNOWN) {
                    convergenceValue = convergeService.convergeEndpoint(uniCallKind, value.toString());
                    this.addConvergeAttribute(metricsAttributesBuilder, spanAttributesBuilder, value, convergenceValue, key);
                } else {
                    this.addAttribute(metricsAttributesBuilder, value, key);
                }
            }
        } else if (ArmsConstants.HashcodeKeys.PRPC == keyHashcode) {
            this.addAttribute(spanAttributesBuilder, value, key);
            if (ArmsDataDegradationStateAdapter.INSTANCE.isEnablePRpcInMetric()) {
                if (convergeService != null && uniCallKind != UniCallKind.UNKNOWN) {
                    convergenceValue = convergeService.convergePrpc(value.toString());
                    this.addConvergeAttribute(metricsAttributesBuilder, spanAttributesBuilder, value, convergenceValue, key);
                } else {
                    this.addAttribute(metricsAttributesBuilder, value, key);
                }
            }
        } else if (ArmsConstants.HashcodeKeys.PPID == keyHashcode) {
            this.addAttribute(spanAttributesBuilder, value, key);
            if (ArmsDataDegradationStateAdapter.INSTANCE.isEnablePPidInMetric()) {
                if (convergeService != null && uniCallKind != UniCallKind.UNKNOWN) {
                    convergenceValue = convergeService.convergeDynamic(key.getKey(), value.toString());
                    this.addConvergeAttribute(metricsAttributesBuilder, spanAttributesBuilder, value, convergenceValue, key);
                } else {
                    this.addAttribute(metricsAttributesBuilder, value, key);
                }
            }
        } else if (ArmsConstants.HashcodeKeys.RPC == keyHashcode) {
            if (convergeService != null && uniCallKind != UniCallKind.UNKNOWN) {
                convergenceValue = convergeService.convergeRpc(uniCallKind, value.toString());
                this.addConvergeAttribute(metricsAttributesBuilder, spanAttributesBuilder, value, convergenceValue, key);
            } else {
                this.addAttribute(metricsAttributesBuilder, value, key);
            }
            if (!ArmsProperties.armsSpanDiscardAttributesKeySet.contains(keyStr)) {
                this.addAttribute(spanAttributesBuilder, value, key);
            }
        } else if (key.getType() == AttributeType.STRING) {
            if (ArmsProperties.isMetricsAttributes(key) || keyStr.startsWith("_traffic_")) {
                if (convergeService != null && uniCallKind != UniCallKind.UNKNOWN) {
                    convergenceValue = convergeService.convergeDynamic(keyStr, value.toString());
                    this.addConvergeAttribute(metricsAttributesBuilder, spanAttributesBuilder, value, convergenceValue, key);
                } else {
                    this.addAttribute(metricsAttributesBuilder, value, key);
                }
            }
            if (!ArmsProperties.armsSpanDiscardAttributesKeySet.contains(keyStr)) {
                this.addAttribute(spanAttributesBuilder, value, key);
            }
        } else {
            if (ArmsProperties.isMetricsAttributes(key) || keyStr.startsWith("_traffic_")) {
                this.addAttribute(metricsAttributesBuilder, value, key);
            } else if (ArmsConstants.AttributeKeys.REQUEST_SIZE_KEY.equals(key) || ArmsConstants.AttributeKeys.RESPONSE_SIZE_KEY.equals(key) || "gen_ai.usage.input_tokens".equals(keyStr) || "gen_ai.usage.output_tokens".equals(keyStr)) {
                this.addAttribute(recordAttributesBuilder, value, key);
            } else if (ArmsConstants.AttributeKeys.RPC_TYPE_ENUM_INDEX_KEY.equals(key)) {
                Long rpcTypeIndex = (Long)value;
                this.addCallType(metricsAttributesBuilder, rpcTypeIndex);
            }
            if (!ArmsProperties.armsSpanDiscardAttributesKeySet.contains(keyStr)) {
                this.addAttribute(spanAttributesBuilder, value, key);
            }
        }
    }

    private <K> void addConvergeAttribute(AttributesBuilder metricsAttributesBuilder, AttributesBuilder spanAttributesBuilder, Object value, String convergenceValue, AttributeKey<K> key) {
        this.addAttribute(metricsAttributesBuilder, convergenceValue, key);
        if (convergenceValue != null && !convergenceValue.equals(value)) {
            spanAttributesBuilder.put(key.getKey() + ".convergence", convergenceValue);
        }
    }

    private void addCallType(AttributesBuilder metricsAttributesBuilder, Long rpcTypeIndex) {
        ArmsRpcTypeEnum armsRpcTypeEnum = ArmsRpcTypeEnum.getByIndex(rpcTypeIndex);
        String callType = armsRpcTypeEnum.getName();
        if (callType != null && !callType.isEmpty()) {
            metricsAttributesBuilder.put(ArmsConstants.AttributeKeys.ARMS_CALL_TYPE_KEY, callType);
        }
    }

    private <K> void addAttribute(AttributesBuilder attribute, Object data, AttributeKey<K> attributeKey) {
        attribute.put(attributeKey, data);
    }

    @Override
    public <T> AttributesBuilder put(AttributeKey<Long> key, int value) {
        return this.put((AttributeKey<T>)key, (T)Long.valueOf(value));
    }

    @Override
    public <T> AttributesBuilder put(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        this.data.add(key);
        this.data.add(value);
        return this;
    }

    @Override
    public AttributesBuilder putAll(Attributes attributes) {
        if (attributes == null) {
            return this;
        }
        attributes.forEach((key, value) -> this.put((AttributeKey<T>)((AttributeKey)key), (T)value));
        return this;
    }

    @Override
    public <T> AttributesBuilder remove(AttributeKey<T> key) {
        if (key == null || key.getKey().isEmpty()) {
            return this;
        }
        return this.removeIf(entryKey -> key.getKey().equals(entryKey.getKey()) && key.getType().equals((Object)entryKey.getType()));
    }

    @Override
    public AttributesBuilder removeIf(Predicate<AttributeKey<?>> predicate) {
        if (predicate == null) {
            return this;
        }
        for (int i = 0; i < this.data.size() - 1; i += 2) {
            Object entry = this.data.get(i);
            if (!(entry instanceof AttributeKey) || !predicate.test((AttributeKey)entry)) continue;
            this.data.remove(i + 1);
            this.data.remove(i);
        }
        return this;
    }
}

