/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.CompositeAttributesBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ImmutableKeyValuePairs;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CompositeAttributes
extends ImmutableKeyValuePairs<AttributeKey<?>, Object>
implements Attributes {
    static final Attributes EMPTY = Attributes.builder().build();
    private int hashcode;
    private int hashArray;

    CompositeAttributes(Object[] data) {
        super(data);
        for (int i = 1; i < data.length; i += 2) {
            this.hashArray = 31 * this.hashArray + (data[i] == null ? 0 : data[i].hashCode());
        }
    }

    @Override
    public CompositeAttributesBuilder toBuilder() {
        return new CompositeAttributesBuilder(new ArrayList<Object>(this.data()));
    }

    @Override
    @Nullable
    public <T> T get(AttributeKey<T> key) {
        return (T)super.get(key);
    }

    static Attributes toAttributes(Object ... data) {
        return new CompositeAttributes(data);
    }

    public int hashCode() {
        int result = this.hashcode;
        if (result == 0) {
            result = 1;
            result *= 1000003;
            this.hashcode = result ^= this.hashArray;
        }
        return result;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompositeAttributes)) {
            return false;
        }
        CompositeAttributes that = (CompositeAttributes)o;
        if (this.data.length != that.data.length) {
            return false;
        }
        for (int i = 1; i < this.data.length; i += 2) {
            if (Objects.equals(this.data[i], that.data[i])) continue;
            return false;
        }
        return true;
    }
}

