/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages.AutoValue_ToolCallRequestPart;
import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages.MessagePart;
import javax.annotation.Nullable;

@JsonClassDescription(value="Tool call request part")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@AutoValue
public abstract class ToolCallRequestPart
implements MessagePart {
    @Override
    @JsonProperty(required=true, value="type")
    @JsonPropertyDescription(value="The type of the content captured in this part")
    public abstract String getType();

    @JsonProperty(value="id")
    @JsonPropertyDescription(value="Unique identifier for the tool call")
    @Nullable
    public abstract String getId();

    @JsonProperty(required=true, value="name")
    @JsonPropertyDescription(value="Name of the tool")
    public abstract String getName();

    @JsonProperty(value="arguments")
    @JsonPropertyDescription(value="Arguments for the tool call")
    @Nullable
    public abstract Object getArguments();

    public static ToolCallRequestPart create(String name) {
        return new AutoValue_ToolCallRequestPart("tool_call", null, name, null);
    }

    public static ToolCallRequestPart create(String id, String name, Object arguments) {
        return new AutoValue_ToolCallRequestPart("tool_call", id, name, arguments);
    }
}

