/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages;

import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages.MessagePart;
import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages.OutputMessage;
import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages.TextPart;
import java.util.ArrayList;
import java.util.List;

public class OutputMessages {
    private final List<OutputMessage> messages;

    public List<OutputMessage> getMessages() {
        return this.messages;
    }

    public static OutputMessages create() {
        return new OutputMessages(new ArrayList<OutputMessage>());
    }

    public static OutputMessages create(List<OutputMessage> messages) {
        return new OutputMessages(new ArrayList<OutputMessage>(messages));
    }

    public OutputMessages append(OutputMessage outputMessage) {
        this.messages.add(outputMessage);
        return this;
    }

    public List<OutputMessage> getSerializableObject() {
        return this.messages;
    }

    public OutputMessages merge(int index, OutputMessage chunkMessage) {
        ArrayList<OutputMessage> currentMessages = new ArrayList<OutputMessage>(this.getMessages());
        if (index < 0 || index >= currentMessages.size()) {
            throw new IllegalArgumentException("Index " + index + " is out of bounds for messages list of size " + currentMessages.size());
        }
        OutputMessage existingMessage = (OutputMessage)currentMessages.get(index);
        ArrayList<MessagePart> mergedParts = new ArrayList<MessagePart>(existingMessage.getParts());
        for (MessagePart chunkPart : chunkMessage.getParts()) {
            if (chunkPart instanceof TextPart) {
                TextPart chunkTextPart = (TextPart)chunkPart;
                boolean appended = false;
                for (int i = 0; i < mergedParts.size(); ++i) {
                    MessagePart existingPart = (MessagePart)mergedParts.get(i);
                    if (!(existingPart instanceof TextPart)) continue;
                    TextPart existingTextPart = (TextPart)existingPart;
                    TextPart mergedTextPart = TextPart.create(existingTextPart.getContent() + chunkTextPart.getContent());
                    mergedParts.set(i, mergedTextPart);
                    appended = true;
                    break;
                }
                if (appended) continue;
                mergedParts.add(chunkTextPart);
                continue;
            }
            mergedParts.add(chunkPart);
        }
        String finalFinishReason = chunkMessage.getFinishReason() != null ? chunkMessage.getFinishReason() : existingMessage.getFinishReason();
        OutputMessage mergedMessage = OutputMessage.create(existingMessage.getRole(), mergedParts, finalFinishReason);
        currentMessages.set(index, mergedMessage);
        return new OutputMessages(currentMessages);
    }

    private OutputMessages(List<OutputMessage> messages) {
        this.messages = messages;
    }
}

