/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages.AutoValue_OutputMessage;
import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages.MessagePart;
import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.messages.Role;
import java.util.List;

@JsonClassDescription(value="Output message")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@AutoValue
public abstract class OutputMessage {
    @JsonProperty(required=true, value="role")
    @JsonPropertyDescription(value="Role of response")
    public abstract String getRole();

    @JsonProperty(required=true, value="parts")
    @JsonPropertyDescription(value="List of message parts that make up the message content")
    public abstract List<MessagePart> getParts();

    @JsonProperty(required=true, value="finish_reason")
    @JsonPropertyDescription(value="Reason for finishing the generation")
    public abstract String getFinishReason();

    public static OutputMessage create(String role, List<MessagePart> parts, String finishReason) {
        return new AutoValue_OutputMessage(role, parts, finishReason);
    }

    public static OutputMessage create(Role role, List<MessagePart> parts, String finishReason) {
        return new AutoValue_OutputMessage(role.getValue(), parts, finishReason);
    }
}

