/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.genai;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.genai.AutoValue_MessageCaptureOptions;

@AutoValue
public abstract class MessageCaptureOptions {
    public abstract boolean captureMessageContent();

    public abstract int maxMessageContentLength();

    public abstract CaptureMessageStrategy captureMessageStrategy();

    public static MessageCaptureOptions create(boolean captureMessageContent, int maxMessageContentLength, String captureMessageStrategy) {
        return new AutoValue_MessageCaptureOptions(captureMessageContent, maxMessageContentLength, CaptureMessageStrategy.fromValue(captureMessageStrategy));
    }

    public static enum CaptureMessageStrategy {
        SPAN_ATTRIBUTES("span-attributes"),
        EVENT("event");

        private final String value;

        public String getValue() {
            return this.value;
        }

        private CaptureMessageStrategy(String value) {
            this.value = value;
        }

        public static CaptureMessageStrategy fromValue(String value) {
            for (CaptureMessageStrategy strategy : CaptureMessageStrategy.values()) {
                if (!strategy.value.equals(value)) continue;
                return strategy;
            }
            return SPAN_ATTRIBUTES;
        }
    }
}

