/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.event;

import io.opentelemetry.javaagent.shaded.instrumentation.api.event.AgentAlertNameEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.event.ArmsEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ArmsEventBuilder {
    private Map<String, String> labels;
    private Map<String, String> annotations;
    private Long startsAt;
    private Long endsAt;

    public static ArmsEventBuilder builder(AgentAlertNameEnum agentAlertNameEnum, Long startsAt) {
        Objects.requireNonNull(agentAlertNameEnum, "Alert Name must be provided");
        Objects.requireNonNull(agentAlertNameEnum, "Event start timestamp must provided");
        ArmsEventBuilder builder = new ArmsEventBuilder();
        builder.labels = new HashMap<String, String>();
        builder.annotations = new HashMap<String, String>();
        builder.labels.put("alertname", agentAlertNameEnum.getAlertName());
        builder.annotations.put("event_description", agentAlertNameEnum.getDesc());
        builder.startsAt = startsAt;
        return builder;
    }

    ArmsEventBuilder() {
    }

    public ArmsEventBuilder setCritical() {
        this.labels.put("severity", "critical");
        return this;
    }

    public ArmsEventBuilder isAgentSelfMonitor() {
        this.labels.put("usage", "agentSelfMonitor");
        return this;
    }

    public ArmsEventBuilder setError() {
        this.labels.put("severity", "error");
        return this;
    }

    public ArmsEventBuilder setWarning() {
        this.labels.put("severity", "warning");
        return this;
    }

    public ArmsEventBuilder setPage() {
        this.labels.put("severity", "page");
        return this;
    }

    public ArmsEventBuilder message(String message) {
        this.annotations.put("message", message);
        return this;
    }

    public ArmsEventBuilder annotation(String k, String v) {
        this.annotations.put(k, v);
        return this;
    }

    public ArmsEventBuilder label(String k, String v) {
        this.labels.put(k, v);
        return this;
    }

    public ArmsEventBuilder label(Map<String, String> labels) {
        this.labels.putAll(labels);
        return this;
    }

    public ArmsEventBuilder endsAt(Long endsAt) {
        this.endsAt = endsAt;
        return this;
    }

    public ArmsEvent build() {
        return new ArmsEvent(this.labels, this.annotations, this.startsAt, this.endsAt);
    }
}

