/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.edas.logconfig;

import io.opentelemetry.javaagent.shaded.instrumentation.api.edas.EdasUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.edas.logconfig.LogAgent;
import io.opentelemetry.javaagent.shaded.instrumentation.api.edas.logconfig.LogAgentEvent;
import io.opentelemetry.javaagent.shaded.instrumentation.api.edas.logconfig.LogAgentManager;
import io.opentelemetry.javaagent.shaded.instrumentation.api.edas.logconfig.LogConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.mse.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class LogAgentStaticManager {
    public static final String SPRINT_BOOT_START = "org.springframework.boot.SpringApplication.run";
    private static final String TOMCAT_START = "org.apache.catalina.core.StandardContext.startInternal";
    public static final String SPRING = "org.springframework.context.ApplicationContext";
    public static final String SPRING_BOOT = "org.springframework.boot.CommandLineRunner";
    public static LogAgentManager logAgentManager = null;
    public static Map<String, AtomicInteger> configFileReference = new ConcurrentHashMap<String, AtomicInteger>();

    public static void register(LogAgent logAgent) {
        if (logAgentManager == null) {
            return;
        }
        logAgentManager.register(logAgent);
    }

    public static void unRegister(LogAgent logAgent) {
        if (logAgentManager == null) {
            return;
        }
        logAgentManager.unRegister(logAgent);
    }

    public static void onEvent(LogAgentEvent event) {
        if (logAgentManager == null) {
            return;
        }
        logAgentManager.onEvent(event);
    }

    public static LogAgentEnv detect(ClassLoader classLoader) {
        Class<?> aClass2;
        LogAgentEnv logAgentEnv = new LogAgentEnv();
        String name = SPRING;
        try {
            aClass2 = classLoader.loadClass(name);
            logAgentEnv.isSpring = aClass2.getClassLoader().equals(classLoader);
        }
        catch (ClassNotFoundException aClass2) {
            // empty catch block
        }
        if (logAgentEnv.isSpring) {
            try {
                name = SPRING_BOOT;
                aClass2 = classLoader.loadClass(name);
                logAgentEnv.isSpringBoot = aClass2.getClassLoader().equals(classLoader);
            }
            catch (ClassNotFoundException aClass3) {
                // empty catch block
            }
        }
        if (Thread.currentThread().getId() == 1L || Thread.currentThread().getName().equals("main")) {
            logAgentEnv.isInStartProcess = true;
        } else {
            String startStack = LogAgentStaticManager.genCurrentThreadStack();
            if (logAgentEnv.isSpringBoot && startStack.contains(SPRINT_BOOT_START)) {
                logAgentEnv.isInStartProcess = true;
            } else if (startStack.contains(TOMCAT_START)) {
                logAgentEnv.isInStartProcess = true;
            }
        }
        return logAgentEnv;
    }

    private static String genCurrentThreadStack() {
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        new Exception("").printStackTrace(printWriter);
        String startStack = out.toString();
        return startStack;
    }

    public static synchronized FileReference createFileIfNotExists(LogConfig logConfig) throws IOException {
        String agentDir = EdasUtils.getAgentDir();
        String path = agentDir + File.separator + ".applied_" + logConfig.framework + "_config_file_" + logConfig.id + "_" + logConfig.lastModifiedTime + "." + logConfig.format;
        return LogAgentStaticManager.createFileIfNotExists(path, logConfig.content);
    }

    public static synchronized FileReference createFileIfNotExists(String path, String content) throws IOException {
        AtomicInteger counter = configFileReference.get(path);
        if (counter != null) {
            counter.incrementAndGet();
            return new FileReference(path, new File(path));
        }
        File file = new File(path);
        if (file.exists()) {
            LogAgentStaticManager.makeFileReferenceCounter(path);
            return new FileReference(path, file);
        }
        IOUtils.writeFile(content, file);
        LogAgentStaticManager.makeFileReferenceCounter(path);
        return new FileReference(path, file);
    }

    private static synchronized void closeFileReference(FileReference fileReference) {
        AtomicInteger counter = configFileReference.get(fileReference.path);
        if (counter.decrementAndGet() <= 0) {
            fileReference.file.delete();
            configFileReference.remove(fileReference.path);
        }
    }

    private static void makeFileReferenceCounter(String path) {
        AtomicInteger counter = new AtomicInteger(0);
        configFileReference.put(path, counter);
        counter.incrementAndGet();
    }

    public static void collectLoggerMethodMap(Class<?> clazz, Set<String> methodNames, Map<String, Method> methodMap, AtomicInteger count) {
        Method[] declaredMethods;
        if (logAgentManager == null) {
            return;
        }
        for (Method item : declaredMethods = clazz.getDeclaredMethods()) {
            if (!methodNames.contains(item.getName())) continue;
            count.incrementAndGet();
            String methodFullDesc = logAgentManager.getMethodFullDesc(item);
            methodMap.put(methodFullDesc.intern(), item);
        }
    }

    public static String mergeXMLFiles(List<URL> urls, Map<String, String> loggerLevelMap, String topElementName, String framework) throws Throwable {
        return logAgentManager.mergeXMLFiles(urls, loggerLevelMap, topElementName, framework);
    }

    public static String mergeProperties(List<URL> urls) throws Throwable {
        return logAgentManager.mergeProperties(urls);
    }

    public static String mergeLog4jJSONConfig(List<URL> urls, Map<String, String> loggerLevelMap) throws Throwable {
        return logAgentManager.mergeLog4jJSONConfig(urls, loggerLevelMap);
    }

    public static String mergeLog4jYamlConfig(List<URL> urls, Map<String, String> loggerLevelMap) throws Throwable {
        return logAgentManager.mergeLog4jYamlConfig(urls, loggerLevelMap);
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.equals(object2);
    }

    public static String urlsToString(List<URL> configURLs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < configURLs.size(); ++i) {
            sb.append(configURLs.get(i).toExternalForm());
            if (i >= configURLs.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void onReceiveConfigInfo(String framework, String configInfo) {
        logAgentManager.onReceiveConfigInfo(framework, configInfo);
    }

    public static class FileReference {
        public String path;
        public File file;
        boolean closed;

        public FileReference(String path, File file) {
            this.path = path;
            this.file = file;
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            LogAgentStaticManager.closeFileReference(this);
        }
    }

    public static class LogAgentEnv {
        public boolean isSpring;
        public boolean isSpringBoot;
        public boolean isInStartProcess;
    }
}

