/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class HttpUtils {
    private static final PatchLogger logger = PatchLogger.getLogger(HttpUtils.class.getName());

    public static String extractHttpRequestPath(String url) {
        if (url == null) {
            return null;
        }
        try {
            int endIndex = url.indexOf("?");
            if (endIndex == -1) {
                endIndex = url.length();
            }
            if (url.startsWith("http://")) {
                int beginIdx = url.indexOf("/", 7);
                if (beginIdx > 0) {
                    return url.substring(beginIdx, endIndex);
                }
                return "/";
            }
            if (url.startsWith("https://")) {
                int beginIdx = url.indexOf("/", 8);
                if (beginIdx > 0) {
                    return url.substring(beginIdx, endIndex);
                }
                return "/";
            }
            return url.substring(0, endIndex);
        }
        catch (Throwable t) {
            return url;
        }
    }

    public static Map<String, List<String>> extractHttpRequestParameters(@Nullable String rawQuery) {
        if (rawQuery == null || rawQuery.isEmpty()) {
            return Collections.emptyMap();
        }
        return HttpUtils.parseRequestParameters(rawQuery, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String strUrl, int connectionTimeout, int readTimeout) {
        BufferedReader in = null;
        try {
            String inputLine;
            URL url = new URL(strUrl);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", "Alibaba Cloud One Agent");
            con.setConnectTimeout(connectionTimeout);
            con.setReadTimeout(readTimeout);
            in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            String string = content.toString();
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Map<String, List<String>> parseRequestParameters(String rawQuery, String charset) {
        if (rawQuery != null && !rawQuery.trim().isEmpty()) {
            String[] keyValuePair;
            HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
            for (String keyValue : keyValuePair = rawQuery.split("&")) {
                int index;
                if (keyValue == null || keyValue.isEmpty() || (index = keyValue.indexOf(61)) < 0) continue;
                String key = keyValue.substring(0, index);
                String value = keyValue.substring(index + 1);
                if (key.isEmpty()) continue;
                try {
                    key = URLDecoder.decode(key, charset);
                    value = URLDecoder.decode(value, charset);
                }
                catch (UnsupportedEncodingException e) {
                    logger.log(Level.FINE, "[extractHttpRequestParameters] decode exception", e);
                }
                List<String> list = null;
                if (!queryParams.containsKey(key)) {
                    list = new ArrayList();
                    queryParams.put(key, list);
                } else {
                    list = (List)queryParams.get(key);
                }
                list.add(value);
            }
            return queryParams;
        }
        return Collections.emptyMap();
    }
}

