/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

public class ArmsMD5 {
    private ArmsMD5() {
    }

    public static String getMD5String(String str) {
        String charset = "GBK";
        return ArmsMD5.getMD5String(str, charset);
    }

    public static String getMD5StringForXtraceProject(String origin) throws NoSuchAlgorithmException {
        byte[] buf = origin.getBytes();
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(buf);
        byte[] tmp = md5.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : tmp) {
            sb.append(Integer.toHexString(b & 0xFF));
        }
        return sb.toString();
    }

    public static String getMD5String(String str, String charset) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(str.getBytes(charset));
            byte[] byteArray = messageDigest.digest();
            StringBuffer md5StrBuff = new StringBuffer();
            for (int i = 0; i < byteArray.length; ++i) {
                if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                    md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
                    continue;
                }
                md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
            }
            return md5StrBuff.toString().toLowerCase(Locale.ROOT);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

