/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.state;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Callback;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.ConfigKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.DataId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Endpoint;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.GroupId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Namespace;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import java.util.logging.Level;

@Endpoint(value=ConfigEnum.ARMS_APP_CONFIG_ENDPOINT)
@DataId(value=ConfigEnum.ARMS_GLOBAL_CONFIG_DATA_ID)
@GroupId(value=ConfigEnum.ARMS_APP_CONFIG_GROUP_ID)
@Namespace(value=ConfigEnum.ARMS_APP_CONFIG_NAMESPACE)
public class ArmsGlobalState
extends State {
    private static final PatchLogger logger = PatchLogger.getLogger(ArmsGlobalState.class.getName());
    @ConfigKey(value="profiler.degrade.enable")
    private volatile boolean globalDegradeEnable = false;
    @ConfigKey(value="profiler.perfsdk.enable")
    private volatile boolean globalPerfSdkEnable = true;
    @ConfigKey(value="profiler.oshi.delaysec", type=Integer.class)
    private volatile int delaySec = ConfigPropertiesUtil.getInt("profiler.oshi.delaysec", 60);
    public static ArmsGlobalState INSTANCE = new ArmsGlobalState();

    public boolean isGlobalDegradeEnable() {
        return ArmsGlobalState.INSTANCE.globalDegradeEnable;
    }

    public boolean isGlobalPerfSdkEnable() {
        return ArmsGlobalState.INSTANCE.globalPerfSdkEnable;
    }

    public int getDelaySec() {
        return this.delaySec;
    }

    public void setGlobalPerfSdkEnable(boolean globalPerfSdkEnable) {
        this.globalPerfSdkEnable = globalPerfSdkEnable;
    }

    public ArmsGlobalState() {
        if (this.getClass().getName().equals(ArmsGlobalState.class.getName())) {
            super.registerConfigInstance(this);
        }
    }

    public static ArmsGlobalState getINSTANCE() {
        return INSTANCE;
    }

    @Callback
    public void onConfigChange(String configInfo) {
        logger.log(Level.INFO, "[ArmsGlobalState] Global degrade status changed, current status: {0}", this.globalDegradeEnable);
    }

    public void setGlobalDegradeEnable(boolean globalDegradeEnable) {
        this.globalDegradeEnable = globalDegradeEnable;
    }
}

