/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.state;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.degradation.ArmsDataDegradationService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.degradation.ArmsDataDegradationStateAdapter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.state.ArmsState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.ConfigEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.ConfigKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.DataId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Endpoint;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.GroupId;
import io.opentelemetry.javaagent.shaded.instrumentation.api.config.annotations.Namespace;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;

@Endpoint(value=ConfigEnum.ARMS_APP_CONFIG_ENDPOINT)
@DataId(value=ConfigEnum.ARMS_APP_CONFIG_DATA_ID)
@GroupId(value=ConfigEnum.ARMS_APP_CONFIG_GROUP_ID)
@Namespace(value=ConfigEnum.ARMS_APP_CONFIG_NAMESPACE)
public class ArmsDataDegradationState
extends ArmsState
implements ArmsDataDegradationService {
    public static final ArmsDataDegradationState INSTANCE = new ArmsDataDegradationState();
    @ConfigKey(value="profiler.metrics.report.interval", type=Integer.class)
    private volatile int metricReportInterval = 15;
    @ConfigKey(value="profiler.metrics.prpc.enable")
    private volatile boolean enablePRpcInMetric = true;
    @ConfigKey(value="profiler.metrics.ppid.enable")
    private volatile boolean enablePPidInMetric = true;
    @ConfigKey(value="profiler.metrics.endpoint.enable")
    private volatile boolean enableEndpointInMetric = true;
    @ConfigKey(value="profiler.metrics.destId.enable")
    private volatile boolean enableDestIdnMetric = true;
    @ConfigKey(value="profiler.metrics.quantile.interface.enable")
    private volatile boolean enableQuantile4Interface = true;
    @ConfigKey(value="profiler.metrics.quantile.db.enable")
    private volatile boolean enableQuantile4DB = false;
    @ConfigKey(value="profiler.metrics.quantile.nosql.enable")
    private volatile boolean enableQuantile4NOSQL = false;
    @ConfigKey(value="profiler.metrics.quantile.mq.enable")
    private volatile boolean enableQuantile4MQ = false;
    @ConfigKey(value="profiler.metrics.quantile.outcall.enable")
    private volatile boolean enableQuantile4Outcall = false;
    @ConfigKey(value="profiler.quantile.enable")
    private volatile boolean quantileEnable = true;
    @ConfigKey(value="profiler.metricsAndSpan.entranceless.enable")
    private volatile boolean enableEntrancelessSpanAndMetric = ConfigPropertiesUtil.getBoolean("profiler.metricsAndSpan.entranceless.enable", false);
    @ConfigKey(value="otel.instrumentation.common.experimental.controller-telemetry.enabled")
    private volatile boolean controllerTelemetryEnable = ConfigPropertiesUtil.getBoolean("otel.instrumentation.common.experimental.controller-telemetry.enabled", true);

    private ArmsDataDegradationState() {
        super.registerConfigInstance(this);
        ArmsDataDegradationStateAdapter.setAdaptee(this);
    }

    @Override
    public int getMetricReportInterval() {
        if (this.metricReportInterval == 1 || this.metricReportInterval == 5 || this.metricReportInterval == 15 || this.metricReportInterval == 30 || this.metricReportInterval == 60) {
            return this.metricReportInterval;
        }
        return 15;
    }

    public boolean isQuantileEnable() {
        return this.quantileEnable;
    }

    @Override
    public boolean isEnablePRpcInMetric() {
        return this.enablePRpcInMetric;
    }

    @Override
    public boolean isEnablePPidInMetric() {
        return this.enablePPidInMetric;
    }

    @Override
    public boolean isEnableEndpointInMetric() {
        return this.enableEndpointInMetric;
    }

    @Override
    public boolean isEnableDestIdInMetric() {
        return this.enableDestIdnMetric;
    }

    @Override
    public boolean isEnableQuantile4Interface() {
        return this.enableQuantile4Interface;
    }

    @Override
    public boolean isEnableQuantile4DB() {
        return this.enableQuantile4DB;
    }

    @Override
    public boolean isEnableQuantile4NOSQL() {
        return this.enableQuantile4NOSQL;
    }

    @Override
    public boolean isEnableQuantile4MQ() {
        return this.enableQuantile4MQ;
    }

    @Override
    public boolean isEnableQuantile4Outcall() {
        return this.enableQuantile4Outcall;
    }

    @Override
    public boolean isEnableEntrancelesSpanAndMetrics() {
        return this.enableEntrancelessSpanAndMetric;
    }

    public void setMetricReportInterval(int metricReportInterval) {
        this.metricReportInterval = metricReportInterval;
    }

    public void setEnablePRpcInMetric(boolean enablePRpcInMetric) {
        this.enablePRpcInMetric = enablePRpcInMetric;
    }

    public void setEnablePPidInMetric(boolean enablePPidInMetric) {
        this.enablePPidInMetric = enablePPidInMetric;
    }

    public void setEnableEndpointInMetric(boolean enableEndpointInMetric) {
        this.enableEndpointInMetric = enableEndpointInMetric;
    }

    public void setEnableDestIdnMetric(boolean enableDestIdnMetric) {
        this.enableDestIdnMetric = enableDestIdnMetric;
    }

    public void setQuantileEnable(boolean quantileEnable) {
        this.quantileEnable = quantileEnable;
    }

    public void setEnableQuantile4Interface(boolean enableQuantile4Interface) {
        this.enableQuantile4Interface = enableQuantile4Interface;
    }

    public void setEnableQuantile4DB(boolean enableQuantile4DB) {
        this.enableQuantile4DB = enableQuantile4DB;
    }

    public void setEnableQuantile4NOSQL(boolean enableQuantile4NOSQL) {
        this.enableQuantile4NOSQL = enableQuantile4NOSQL;
    }

    public void setEnableQuantile4MQ(boolean enableQuantile4MQ) {
        this.enableQuantile4MQ = enableQuantile4MQ;
    }

    public void setEnableQuantile4Outcall(boolean enableQuantile4Outcall) {
        this.enableQuantile4Outcall = enableQuantile4Outcall;
    }

    public void setEnableEntrancelessSpanAndMetric(boolean enableEntrancelessSpanAndMetric) {
        this.enableEntrancelessSpanAndMetric = enableEntrancelessSpanAndMetric;
    }

    @Override
    public boolean isControllerTelemetryEnable() {
        return this.controllerTelemetryEnable;
    }

    public void setControllerTelemetryEnable(boolean controllerTelemetryEnable) {
        this.controllerTelemetryEnable = controllerTelemetryEnable;
    }
}

