/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.profiling;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanReader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsMultiThreadSpanEnum;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums.ArmsWallClockStatusType;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.profiling.HotSpotProfiling;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.profiling.ProfilingRunningState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.OtelEncodingUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class HotSpotRecorder {
    private static final PatchLogger logger = PatchLogger.getLogger(HotSpotRecorder.class.getName());
    private static final HotSpotProfiling hotSpotRecordHandler = GlobalInstanceHolder.getInstance(HotSpotProfiling.class);
    private static final int MAX_LOG_BUFFER_SIZE = 1000;
    private static SpanReader spanReader = GlobalInstanceHolder.getInstance(SpanReader.class);
    public static boolean isDebug = false;
    public static final ThreadLocal<StringBuffer> LOG_BUFFER = new ThreadLocal<StringBuffer>(){

        @Override
        protected StringBuffer initialValue() {
            return new StringBuffer();
        }
    };
    private static final ThreadLocal<Integer> LOG_SEQ_NUM = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return new Integer(0);
        }
    };

    private static int getNextNum() {
        int next = (LOG_SEQ_NUM.get() + 1) % 0x7FFFFFFE;
        LOG_SEQ_NUM.set(next);
        return next;
    }

    public static void attach(Context newContext) {
        SpanContext spanContext = HotSpotRecorder.spanFromContextNullSafe(newContext).getSpanContext();
        if (ProfilingRunningState.isWallClockRunning && spanContext.isSampled() && hotSpotRecordHandler != null) {
            Span localRootSpan = LocalRootSpan.fromContext(newContext);
            HotSpotRecorder.writeLog("attach1", localRootSpan, LOG_BUFFER.get());
            if (!Span.getInvalid().equals(localRootSpan)) {
                HotSpotRecorder.writeLog("attach2", localRootSpan, LOG_BUFFER.get());
                HotSpotRecorder.setWallClockPicked(LocalRootSpan.fromContext(Context.current()), Span.fromContext(Context.current()));
                HotSpotRecorder.setWallClockPicked(localRootSpan, Span.fromContext(newContext));
                HotSpotRecorder.setWallClockNominee(localRootSpan);
                hotSpotRecordHandler.recordHotSpotStart(localRootSpan.getSpanContext().getTraceId(), OtelEncodingUtils.longFromBase16String(localRootSpan.getSpanContext().getSpanId(), 0), OtelEncodingUtils.longFromBase16String(spanContext.getSpanId(), 0));
            }
        } else if (hotSpotRecordHandler != null) {
            hotSpotRecordHandler.recordHotSpotEnd();
        }
    }

    public static void detach(Context deactivatedContext, Context preContext) {
        SpanContext spanContext = HotSpotRecorder.spanFromContextNullSafe(deactivatedContext).getSpanContext();
        if (ProfilingRunningState.isWallClockRunning && spanContext.isSampled() && hotSpotRecordHandler != null) {
            Span localRootSpan = LocalRootSpan.fromContext(deactivatedContext);
            hotSpotRecordHandler.removeCurrentThread();
            HotSpotRecorder.setWallClockPicked(localRootSpan, Span.fromContext(deactivatedContext));
            HotSpotRecorder.writeLog("detach1", localRootSpan, LOG_BUFFER.get());
            if (preContext == null || spanContext.getSpanId().equals(localRootSpan.getSpanContext().getSpanId())) {
                HotSpotRecorder.writeLog("detach2", localRootSpan, LOG_BUFFER.get());
                hotSpotRecordHandler.recordHotSpotEnd();
            } else {
                HotSpotRecorder.writeLog("detach3", localRootSpan, LOG_BUFFER.get());
                SpanContext preSpanContext = HotSpotRecorder.spanFromContextNullSafe(preContext).getSpanContext();
                if (!spanContext.getTraceId().equals(preSpanContext.getTraceId())) {
                    localRootSpan.setAttribute("multiThread", String.valueOf(ArmsMultiThreadSpanEnum.MULTI_THREAD.getFlag()));
                    HotSpotRecorder.writeLog("detach4, currentTraceId=" + spanContext.getTraceId() + ", preTraceId=" + preSpanContext.getTraceId(), localRootSpan, LOG_BUFFER.get());
                } else {
                    Span preLocalRootSpan = LocalRootSpan.fromContext(preContext);
                    hotSpotRecordHandler.recordHotSpotStart(preLocalRootSpan.getSpanContext().getTraceId(), OtelEncodingUtils.longFromBase16String(preLocalRootSpan.getSpanContext().getSpanId(), 0), OtelEncodingUtils.longFromBase16String(preSpanContext.getSpanId(), 0));
                }
            }
        } else if (hotSpotRecordHandler != null) {
            hotSpotRecordHandler.recordHotSpotEnd();
        }
    }

    private static Span spanFromContextNullSafe(@Nullable Context context) {
        if (context == null) {
            return Span.getInvalid();
        }
        return Span.fromContext(context);
    }

    private static void setWallClockNominee(Span localRootSpan) {
        if (Span.getInvalid().equals(localRootSpan)) {
            return;
        }
        String attribute = spanReader.getAttribute(localRootSpan, AttributeKey.stringKey("wallClock"));
        if (attribute == null) {
            localRootSpan.setAttribute("wallClock", String.valueOf(ArmsWallClockStatusType.NOMINEE.getStatus()));
        }
    }

    private static void setWallClockPicked(Span localRootSpan, Span span) {
        int samplesCount;
        if (Span.getInvalid().equals(localRootSpan)) {
            return;
        }
        long actualLocalRootSpanId = OtelEncodingUtils.longFromBase16String(localRootSpan.getSpanContext().getSpanId(), 0);
        long actualSpanId = OtelEncodingUtils.longFromBase16String(span.getSpanContext().getSpanId(), 0);
        int n = samplesCount = hotSpotRecordHandler != null ? hotSpotRecordHandler.getSampleCount(localRootSpan.getSpanContext().getTraceId(), actualLocalRootSpanId, actualSpanId) : 0;
        if (samplesCount > 0) {
            HotSpotRecorder.writeLog("setWallClockPicked", localRootSpan, LOG_BUFFER.get());
            localRootSpan.setAttribute("wallClock", String.valueOf(ArmsWallClockStatusType.PICKED.getStatus()));
        }
    }

    public static void setWallClockAttribute(Context context) {
        if (!ProfilingRunningState.isWallClockRunning || !HotSpotRecorder.spanFromContextNullSafe(context).getSpanContext().isSampled()) {
            return;
        }
        HotSpotRecorder.setWallClockPicked(LocalRootSpan.fromContext(context), Span.fromContext(context));
    }

    public static void writeLog(String position, Span span, StringBuffer buffer) {
        if (!isDebug) {
            return;
        }
        SpanContext spanContext = span.getSpanContext();
        String spanName = GlobalInstanceHolder.getInstance(SpanReader.class).readSpanName(span);
        StringBuilder logString = new StringBuilder(System.currentTimeMillis() + "|" + Thread.currentThread().getName() + "|" + position + " traceId=" + spanContext.getTraceId() + " spanId=" + spanContext.getSpanId() + " isSampled=" + spanContext.isSampled() + " spanName=" + spanName);
        if (buffer.length() > 1000) {
            logger.log(Level.FINE, "[CP][DEBUG]#" + HotSpotRecorder.getNextNum() + "\n" + buffer);
            buffer.setLength(0);
        }
        buffer.append(logString + "\n");
    }
}

