/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.flowcontrol;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.flowcontrol.ArmsFlowControlService;
import java.util.concurrent.atomic.AtomicLong;

public enum SimpleTokenBucket {
    INSTANCE;

    private ArmsFlowControlService adaptor;
    private AtomicLong tokens = new AtomicLong(10000L);
    private volatile long lastRefillTimestamp = System.currentTimeMillis();
    private volatile boolean canPass = true;

    public void setAdaptor(ArmsFlowControlService adaptor) {
        this.adaptor = adaptor;
        this.tokens = new AtomicLong(adaptor.getFlowControlThreshold());
    }

    public boolean tryAcquire() {
        if (!this.isFlowControlEnabled()) {
            this.canPass = true;
            return true;
        }
        if (this.tokens.getAndDecrement() > 0L) {
            this.canPass = true;
            return true;
        }
        return this.refill();
    }

    private boolean refill() {
        long now = System.currentTimeMillis();
        long elapsed = now - this.lastRefillTimestamp;
        if (elapsed > 1000L) {
            this.tokens.set(this.getFlowControlThreshold());
            this.lastRefillTimestamp = now;
            this.canPass = true;
            return true;
        }
        this.canPass = false;
        return false;
    }

    public boolean canPass() {
        if (!this.canPass) {
            return this.refill();
        }
        return this.canPass;
    }

    public boolean isFlowControlReportEnabled() {
        return this.adaptor != null && this.adaptor.isFlowControlReportEnabled();
    }

    private boolean isFlowControlEnabled() {
        return this.adaptor != null && this.adaptor.isFlowControlEnabled();
    }

    private long getFlowControlThreshold() {
        return this.adaptor == null ? 10000L : this.adaptor.getFlowControlThreshold();
    }
}

