/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.enums;

import io.opentelemetry.javaagent.shaded.com.alibaba.arms.metrics.spec.UniCallKind;
import io.opentelemetry.javaagent.shaded.com.alibaba.arms.metrics.spec.UniRpcType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum ArmsRpcTypeEnum {
    HTTP_INCOME(UniRpcType.HTTP_INCOME, true, true),
    HTTP(UniRpcType.HTTP_CLIENT, false, false),
    HSF_CONSUMER(UniRpcType.HSF_CONSUMER, false, false),
    HSF_PROVIDER(UniRpcType.HSF_PROVIDER, true, true),
    LOCAL_CALL(UniRpcType.LOCAL_CALL, true, false),
    ASYNC_CALL(UniRpcType.ASYNC_CALL, true, false),
    DB2(UniRpcType.DB2, true, false),
    INFORMIX(UniRpcType.INFORMIX, true, false),
    SEQUOIADB(UniRpcType.SEQUOIADB, true, false),
    GBASE(UniRpcType.GBASE, true, false),
    GAUSSDB(UniRpcType.GAUSSDB, true, false),
    KINGBASE(UniRpcType.KINGBASE, true, false),
    INFLUXDB(UniRpcType.INFLUXDB, true, false),
    CLICKHOUSE(UniRpcType.CLICKHOUSE, true, false),
    MYSQL(UniRpcType.MYSQL, true, false),
    MYBATIS(UniRpcType.MYBATIS, true, false),
    ORACLE(UniRpcType.ORACLE, true, false),
    POSTGRESQL(UniRpcType.POSTGRESQL, true, false),
    MONGODB(UniRpcType.MONGODB, true, false),
    PPAS(UniRpcType.PPAS, true, false),
    SQLSERVER(UniRpcType.SQLSERVER, true, false),
    MARIADB(UniRpcType.MARIADB, true, false),
    DMDB(UniRpcType.DMDB, true, false),
    OCEANBASE(UniRpcType.OCEANBASE, true, false),
    REDIS(UniRpcType.REDIS, true, false),
    MEMCACHED(UniRpcType.MEMCACHED, true, false),
    ELASTICSEARCH(UniRpcType.ELASTICSEARCH, true, false),
    KUDU(UniRpcType.KUDU, true, false),
    CASSANDRA(UniRpcType.CASSANDRA, true, false),
    HBASE(UniRpcType.HBASE, true, false),
    LINDORM(UniRpcType.LINDORM, true, false),
    TDDL(UniRpcType.TDDL, true, false),
    TAIR(UniRpcType.TAIR, true, false),
    S_METAQ(UniRpcType.S_METAQ, false, false),
    R_METAQ(UniRpcType.R_METAQ, true, true),
    S_KAFKA(UniRpcType.S_KAFKA, false, false),
    R_KAFKA(UniRpcType.R_KAFKA, true, true),
    S_NOTIFY(UniRpcType.S_NOTIFY, false, false),
    R_NOTIFY(UniRpcType.R_NOTIFY, true, true),
    S_SMQ(UniRpcType.S_SMQ, false, false),
    R_SMQ(UniRpcType.R_SMQ, true, true),
    S_JMS(UniRpcType.S_JMS, false, false),
    R_JMS(UniRpcType.R_JMS, true, true),
    S_MQTT(UniRpcType.S_MQTT, false, false),
    R_MQTT(UniRpcType.R_MQTT, true, true),
    DUBBO_CONSUMER(UniRpcType.DUBBO_CONSUMER, false, false),
    DUBBO_PROVIDER(UniRpcType.DUBBO_PROVIDER, true, true),
    MOTAN_CONSUMER(UniRpcType.MOTAN_CONSUMER, false, false),
    MOTAN_PROVIDER(UniRpcType.MOTAN_PROVIDER, true, true),
    DSF_CONSUMER(UniRpcType.DSF_CONSUMER, false, false),
    DSF_PROVIDER(UniRpcType.DSF_PROVIDER, true, true),
    GRPC_PROVIDER(UniRpcType.GRPC_PROVIDER, true, true),
    GRPC_CONSUMER(UniRpcType.GRPC_CONSUMER, false, false),
    THRIFT_PROVIDER(UniRpcType.THRIFT_PROVIDER, true, true),
    THRIFT_CONSUMER(UniRpcType.THRIFT_CONSUMER, false, false),
    SOFA_PROVIDER(UniRpcType.SOFA_PROVIDER, true, true),
    SOFA_CONSUMER(UniRpcType.SOFA_CONSUMER, false, false),
    UNKNOWN(UniRpcType.UNKNOWN, true, false),
    USER_METHOD(UniRpcType.USER_METHOD, true, true),
    CLIENT(UniRpcType.CLIENT, false, false),
    SERVER(UniRpcType.SERVER, true, true),
    PRODUCER(UniRpcType.PRODUCER, true, false),
    CONSUMER(UniRpcType.CONSUMER, false, true),
    DB(UniRpcType.DB, true, false),
    XTRACE_OTHER(UniRpcType.XTRACE_OTHER, true, false),
    SCHEDULERX(UniRpcType.SCHEDULERX, true, true),
    XXLJOB(UniRpcType.XXLJOB, true, true),
    SPRING_SCHEDULED(UniRpcType.SPRING_SCHEDULED, true, true),
    QUARTZ(UniRpcType.QUARTZ, true, true),
    ELASTICJOB(UniRpcType.ELASTICJOB, true, true),
    JDK_TIMER(UniRpcType.JDK_TIMER, true, true),
    HIKARICP(UniRpcType.HIKARICP, true, false),
    DRUID(UniRpcType.DRUID, true, false),
    LLM_SERVER(UniRpcType.LLM_SERVER, false, false),
    LLM_CLIENT(UniRpcType.LLM_CLIENT, false, false),
    MCP_SERVER(UniRpcType.MCP_SERVER, false, false),
    MCP_CLIENT(UniRpcType.MCP_CLIENT, false, false);

    private final Integer code;
    private final String protocol;
    private final String name;
    private final boolean compressible;
    private final boolean incoming;
    private final UniCallKind uniCallKind;
    public static final Map<Integer, ArmsRpcTypeEnum> enumRpcType;
    public static final Set<Integer> spanCompressibleRpcType;
    public static final Set<Integer> incomingRpcTypes;
    private static ArmsRpcTypeEnum[] rpcTypeEnumArray;

    private ArmsRpcTypeEnum(UniRpcType rpcType, boolean compressible, boolean incoming) {
        this.code = rpcType.getCode();
        this.protocol = rpcType.getProtocol();
        this.name = rpcType.getName();
        this.compressible = compressible;
        this.incoming = incoming;
        this.uniCallKind = rpcType.getKind();
    }

    public static ArmsRpcTypeEnum fromCode(Integer code) {
        for (ArmsRpcTypeEnum ct : ArmsRpcTypeEnum.values()) {
            if (!ct.code.equals(code)) continue;
            return ct;
        }
        return UNKNOWN;
    }

    public static ArmsRpcTypeEnum getByName(String name) {
        for (ArmsRpcTypeEnum ct : ArmsRpcTypeEnum.values()) {
            if (!ct.name.equalsIgnoreCase(name)) continue;
            return ct;
        }
        return UNKNOWN;
    }

    public static ArmsRpcTypeEnum getByCode(int code) {
        for (ArmsRpcTypeEnum ct : ArmsRpcTypeEnum.values()) {
            if (ct.code != code) continue;
            return ct;
        }
        return UNKNOWN;
    }

    public static ArmsRpcTypeEnum getByIndex(int idx) {
        if (idx < rpcTypeEnumArray.length) {
            return rpcTypeEnumArray[idx];
        }
        return UNKNOWN;
    }

    public static ArmsRpcTypeEnum getByIndex(Long idx) {
        if (idx == null) {
            return UNKNOWN;
        }
        if (idx < (long)rpcTypeEnumArray.length) {
            return rpcTypeEnumArray[idx.intValue()];
        }
        return UNKNOWN;
    }

    public static boolean isInSpanCompressible(int code) {
        return spanCompressibleRpcType.contains(code);
    }

    public static boolean isIncomeRpcType(int code) {
        return incomingRpcTypes.contains(code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getName() {
        return this.name;
    }

    public UniCallKind getUniCallKind() {
        return this.uniCallKind;
    }

    static {
        enumRpcType = new HashMap<Integer, ArmsRpcTypeEnum>();
        spanCompressibleRpcType = new HashSet<Integer>();
        incomingRpcTypes = new HashSet<Integer>();
        for (ArmsRpcTypeEnum ct : ArmsRpcTypeEnum.values()) {
            if (ct.incoming) {
                incomingRpcTypes.add(ct.getCode());
            }
            if (ct.compressible) {
                spanCompressibleRpcType.add(ct.getCode());
            }
            enumRpcType.put(ct.getCode(), ct);
        }
        rpcTypeEnumArray = ArmsRpcTypeEnum.values();
    }
}

