/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsConstants;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsMetricsAttributeKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.tag.TagService;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ArmsProperties {
    private static final PatchLogger logger = PatchLogger.getLogger(ArmsProperties.class.getName());
    private static final Set<String> armsMetricsAttributesKeySet = new HashSet<String>();
    public static final Set<String> armsSpanDiscardAttributesKeySet = new HashSet<String>();
    public static final Set<String> armsSpanResourcesKeySet = new HashSet<String>();
    public static final Map<AttributeKey<?>, AttributeKey<?>> armsSpanConvertAttributesName = new HashMap();
    private static TagService tagService = GlobalInstanceHolder.getInstance(TagService.class);

    public static void initArmsAttributes() {
        try {
            if (tagService != null && tagService.getHostTagsMap() != null) {
                armsMetricsAttributesKeySet.addAll(tagService.getHostTagsMap().keySet());
            }
            for (ArmsMetricsAttributesKey armsMetricsAttributesKey : ArmsMetricsAttributesKey.values()) {
                armsMetricsAttributesKeySet.add(armsMetricsAttributesKey.getValue());
            }
            for (Enum enum_ : ArmsSpanDiscardAttributesKey.values()) {
                armsSpanDiscardAttributesKeySet.add(((ArmsSpanDiscardAttributesKey)enum_).getValue());
            }
            for (Enum enum_ : ArmsSpanResourcesKey.values()) {
                armsSpanResourcesKeySet.add(((ArmsSpanResourcesKey)enum_).getValue());
            }
            for (Enum enum_ : ArmsSpanConvertAttributesNameKey.values()) {
                armsSpanConvertAttributesName.put(((ArmsSpanConvertAttributesNameKey)enum_).getOrigin(), ((ArmsSpanConvertAttributesNameKey)enum_).getConvertedName());
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "[ArmsAttributes] Init ArmsAttributes error!", t);
        }
    }

    public static boolean isMetricsAttributes(AttributeKey<?> key) {
        if (key.getClass().equals(ArmsMetricsAttributeKey.class)) {
            return true;
        }
        return key.getKey().equals("messaging.batch.message_count");
    }

    static {
        ArmsProperties.initArmsAttributes();
    }

    static enum ArmsMetricsAttributesKey {
        RPC_TYPE("rpcType"),
        SERVICE_TYPE("serviceType"),
        PID("pid"),
        SERVICE("service"),
        RPC("rpc"),
        HOST("host"),
        PRPC("prpc"),
        PPID("ppid"),
        DEST_ID("destId"),
        ENDPOINT("endpoint"),
        EXCEP_TYPE("excepType"),
        EXCEP_INFO("excepInfo"),
        EXCEP_NAME("excepName"),
        SQL_ID("sqlId"),
        SERVER_IP("serverIp"),
        QUANTILE("quantile"),
        STATUS("status"),
        OP_TYPE("opType"),
        RESULT_BYTES("result_bytes"),
        RESULT_SIZE("result_size"),
        DELAY_MILLISECONDS("delay_milliseconds"),
        MESSAGE_DELAY_MILLISECONDS("messaging.consume.delay_ms"),
        HIT_COUNT("hit_count"),
        CUSTOM_ERROR_FLAG("_ext_err_source"),
        MESSAGING_BATCH_MESSAGE_COUNT("messaging.batch.message_count");

        private String value;

        private ArmsMetricsAttributesKey(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    static enum ArmsSpanDiscardAttributesKey {
        RPC("rpc"),
        SQL_ID("sqlId"),
        EXCEPTION_INFO("excepInfo"),
        EXCEPTION_TYPE("excepType"),
        RPC_TYPE_ENUM_INDEX(ArmsConstants.AttributeKeys.RPC_TYPE_ENUM_INDEX_KEY.getKey()),
        SPAN_ROOT_CLOSED_KEY("arms_span_root_closed"),
        SPAN_ROOT_CLOSED_TIME_KEY("arms_span_root_closed_time"),
        CUSTOM_ERROR_METRIC_LABEL_KEY("_ext_err_source"),
        MODEL_NAME("modelName"),
        SPAN_KIND("spanKind");

        private String value;

        private ArmsSpanDiscardAttributesKey(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    static enum ArmsSpanResourcesKey {
        IP_V4("ipv4"),
        ARMS_APPID("arms.appId"),
        SERVICE_NAME("service.name");

        private String value;

        private ArmsSpanResourcesKey(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    static enum ArmsSpanConvertAttributesNameKey {
        ENDPOINT(AttributeKey.stringKey("endpoint"), AttributeKey.stringKey("endpoint.id")),
        RPC_TYPE(AttributeKey.longKey("rpcType"), AttributeKey.longKey("rpc.type")),
        SERVICE_TYPE(AttributeKey.longKey("serviceType"), AttributeKey.longKey("service.type")),
        DESTINATION(AttributeKey.stringKey("destId"), AttributeKey.stringKey("destination.id"));

        private AttributeKey<?> origin;
        private AttributeKey<?> convertedName;

        private ArmsSpanConvertAttributesNameKey(AttributeKey<?> origin, AttributeKey<?> convertedName) {
            this.origin = origin;
            this.convertedName = convertedName;
        }

        public AttributeKey<?> getOrigin() {
            return this.origin;
        }

        public AttributeKey<?> getConvertedName() {
            return this.convertedName;
        }
    }
}

