/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeType;
import java.util.List;
import javax.annotation.Nullable;

public class ArmsMetricsAttributeKey<T>
implements AttributeKey<T> {
    private String key;
    private AttributeType type;
    private int hashcode;

    private ArmsMetricsAttributeKey(String key, AttributeType type) {
        this.key = key;
        this.type = type;
        this.hashcode = ArmsMetricsAttributeKey.buildHashCode(type, key);
    }

    static AttributeKey<String> stringKey(String key) {
        return new ArmsMetricsAttributeKey<String>(key, AttributeType.STRING);
    }

    static AttributeKey<Boolean> booleanKey(String key) {
        return new ArmsMetricsAttributeKey<Boolean>(key, AttributeType.BOOLEAN);
    }

    static AttributeKey<Long> longKey(String key) {
        return new ArmsMetricsAttributeKey<Long>(key, AttributeType.LONG);
    }

    static AttributeKey<Double> doubleKey(String key) {
        return new ArmsMetricsAttributeKey<Double>(key, AttributeType.DOUBLE);
    }

    static AttributeKey<List<String>> stringArrayKey(String key) {
        return new ArmsMetricsAttributeKey<List<String>>(key, AttributeType.STRING_ARRAY);
    }

    static AttributeKey<List<Boolean>> booleanArrayKey(String key) {
        return new ArmsMetricsAttributeKey<List<Boolean>>(key, AttributeType.BOOLEAN_ARRAY);
    }

    static AttributeKey<List<Long>> longArrayKey(String key) {
        return new ArmsMetricsAttributeKey<List<Long>>(key, AttributeType.LONG_ARRAY);
    }

    static AttributeKey<List<Double>> doubleArrayKey(String key) {
        return new ArmsMetricsAttributeKey<List<Double>>(key, AttributeType.DOUBLE_ARRAY);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public AttributeType getType() {
        return this.type;
    }

    public String toString() {
        return this.key;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeKey)) {
            return false;
        }
        AttributeKey that = (AttributeKey)o;
        return this.type.equals((Object)that.getType()) && this.key.equals(that.getKey());
    }

    public int hashCode() {
        return this.hashcode;
    }

    private static int buildHashCode(AttributeType type, String key) {
        int result = 1;
        result *= 1000003;
        result ^= type.hashCode();
        result *= 1000003;
        return result ^= key.hashCode();
    }
}

