/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.extract.enums;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.extract.enums.ExtractTypeEnum;

public enum ExtractSourceEnum {
    UNKNOWN(0, -1, 0),
    PARAMETER(1, 0, 25),
    HEADER(2, 1, 51),
    BODY(4, 2, 3),
    COOKIE(8, 3, 3),
    MESSAGE(16, 4, 4),
    RETURN(32, 5, 8);

    public final int mask;
    public final int maskIndex;
    public final int supportSource;

    private ExtractSourceEnum(int mask, int maskIndex, int supportSource) {
        this.mask = mask;
        this.maskIndex = maskIndex;
        this.supportSource = supportSource;
    }

    public boolean isSupported(ExtractTypeEnum type) {
        return (this.supportSource & type.code) > 0;
    }

    public static ExtractSourceEnum getEnumByName(String name) {
        try {
            return ExtractSourceEnum.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }
}

