/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.biz_trace;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.AliyunContextHolderUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;

public final class ArmsBizCode {
    public static void storeInContext(Context context, Set<String> bizCodeSet) {
        AliyunContextHolderUtils.putToAliyunContext("biz.o11y.code-list", bizCodeSet, context);
    }

    public static Set<?> appendInContext(Context context, Set<String> bizCodeSetToAppend) {
        Set<Object> bizCodeSet = ArmsBizCode.fromContextOrNull(context);
        if (bizCodeSet == null) {
            ArmsBizCode.storeInContext(context, bizCodeSetToAppend);
            return bizCodeSetToAppend;
        }
        bizCodeSet.addAll(bizCodeSetToAppend);
        return bizCodeSet;
    }

    public static Set<Object> fromContext(Context context) {
        HashSet result = ArmsBizCode.fromContextOrNull(context);
        return result == null ? new HashSet() : result;
    }

    public static Set<Object> fromContextOrNull(Context context) {
        Object bizCodeList = AliyunContextHolderUtils.getFromAliyunContext("biz.o11y.code-list", context);
        if (bizCodeList instanceof Set) {
            return (Set)bizCodeList;
        }
        return null;
    }

    public static Set<String> restoreBizCode(String bizCodes) {
        if (bizCodes == null || bizCodes.isEmpty()) {
            return new HashSet<String>();
        }
        String[] split = bizCodes.split(",");
        HashSet<String> bizCodeList = new HashSet<String>(split.length << 1);
        bizCodeList.addAll(Arrays.asList(split));
        return bizCodeList;
    }

    public static String serializeBizCode(Collection<?> bizCodeList) {
        StringJoiner sj = new StringJoiner(",");
        for (Object bizCode : bizCodeList) {
            if (!(bizCode instanceof String)) continue;
            sj.add((String)bizCode);
        }
        return sj.toString();
    }
}

