/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.BusinessObservabilityService;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.biz_o11y.biz_trace.ArmsBizCode;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.MetricsRecorder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.Set;
import java.util.logging.Level;

public class ArmsBusinessObservabilityMetrics
implements MetricsRecorder {
    private static final PatchLogger LOGGER = PatchLogger.getLogger(ArmsBusinessObservabilityMetrics.class.getName());
    protected final LongCounter totalRequestCount;
    protected final LongCounter errorRequestCount;
    protected final LongCounter slowRequestCount;
    protected final LongCounter requestDuration;
    BusinessObservabilityService businessObservabilityService = GlobalInstanceHolder.getInstance(BusinessObservabilityService.class);

    public ArmsBusinessObservabilityMetrics(Meter meter) {
        this.totalRequestCount = meter.counterBuilder("arms_biz_rpc_requests_count").setUnit("{requests}").setDescription("The number of concurrent business requests that are currently in-flight").build();
        this.errorRequestCount = meter.counterBuilder("arms_biz_rpc_requests_error_count").setUnit("{requests}").setDescription("The number of concurrent error business requests that are currently in-flight").build();
        this.slowRequestCount = meter.counterBuilder("arms_biz_rpc_requests_slow_count").setUnit("{requests}").setDescription("The number of concurrent slow business requests that are currently in-flight").build();
        this.requestDuration = meter.counterBuilder("arms_biz_rpc_requests_seconds").setUnit("{ms}").setDescription("The average duration of concurrent business requests that are currently in-flight").build();
    }

    public void onEnd(Context context, Attributes attributes, MetricState metricState) {
        if (this.businessObservabilityService == null) {
            LOGGER.log(Level.INFO, "Business observability has not been initialized.");
            return;
        }
        if (!this.businessObservabilityService.isBizO11yEnable()) {
            return;
        }
        Set<Object> bizCodeList = ArmsBizCode.fromContext(context);
        if (bizCodeList.isEmpty()) {
            return;
        }
        AttributesBuilder bizAttributesBuilder = Attributes.builder().putAll(attributes);
        for (Object bizCodeObj : bizCodeList) {
            if (!(bizCodeObj instanceof String)) continue;
            Attributes bizAttributes = bizAttributesBuilder.put("_biz_code", (String)bizCodeObj).build();
            this.totalRequestCount.add(metricState.total(), bizAttributes, context);
            this.requestDuration.add(metricState.duration(), bizAttributes, context);
            if (metricState.error() > 0L) {
                this.errorRequestCount.add(metricState.error(), bizAttributes);
            }
            if (metricState.slow() <= 0L) continue;
            this.slowRequestCount.add(metricState.slow(), bizAttributes);
        }
    }

    public static class MetricState {
        long[] state = new long[4];

        public MetricState recordTotal(long count) {
            this.state[0] = count;
            return this;
        }

        public MetricState recordDuration(long cost) {
            this.state[1] = cost;
            return this;
        }

        public MetricState recordError(long count) {
            this.state[2] = count;
            return this;
        }

        public MetricState recordSlow(long count) {
            this.state[3] = count;
            return this;
        }

        public long total() {
            return this.state[0];
        }

        public long duration() {
            return this.state[1];
        }

        public long error() {
            return this.state[2];
        }

        public long slow() {
            return this.state[3];
        }
    }
}

