/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.matcher;

import java.util.ArrayDeque;
import java.util.Map;

public class AdviceRuleMatcher {
    public static boolean parseBoolExpr(Map<String, Boolean> matchResult, String rule) {
        if (rule.equals("*")) {
            for (Map.Entry<String, Boolean> entry : matchResult.entrySet()) {
                if (entry.getValue().booleanValue()) continue;
                return false;
            }
            return true;
        }
        for (Map.Entry<String, Boolean> entry : matchResult.entrySet()) {
            rule = rule.replace(entry.getKey(), entry.getValue() != false ? "t" : "f");
        }
        ArrayDeque<Character> nums = new ArrayDeque<Character>();
        ArrayDeque<Character> ops = new ArrayDeque<Character>();
        for (char c : rule.toCharArray()) {
            if (c == ',') continue;
            if (c == 't' || c == 'f') {
                nums.addLast(Character.valueOf(c));
            }
            if (c == '|' || c == '&' || c == '!') {
                ops.addLast(Character.valueOf(c));
            }
            if (c == '(') {
                nums.addLast(Character.valueOf('-'));
            }
            if (c != ')') continue;
            char op = ((Character)ops.pollLast()).charValue();
            char cur = ' ';
            while (!nums.isEmpty() && ((Character)nums.peekLast()).charValue() != '-') {
                char top = ((Character)nums.pollLast()).charValue();
                cur = cur == ' ' ? top : AdviceRuleMatcher.calc(top, cur, op);
            }
            if (op == '!') {
                cur = cur == 't' ? (char)'f' : 't';
            }
            nums.pollLast();
            nums.addLast(Character.valueOf(cur));
        }
        return !nums.isEmpty() && ((Character)nums.peekLast()).charValue() == 't';
    }

    static char calc(char a, char b, char op) {
        boolean x = a == 't';
        boolean y = b == 't';
        boolean ans = op == '|' ? x | y : x & y;
        return ans ? (char)'t' : 'f';
    }
}

