/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.TextMatcherTypeEnum;
import java.util.regex.Pattern;

public class TextMatcher {
    private static final double ERROR_LIMIT = 0.001;

    public static boolean plainTextMatches(TextMatcherTypeEnum matchType, String pattern, String input) {
        if (matchType == TextMatcherTypeEnum.EQUALS) {
            return StringUtils.equals(input, pattern);
        }
        if (matchType == TextMatcherTypeEnum.START_WITH) {
            return StringUtils.startsWith(input, pattern);
        }
        if (matchType == TextMatcherTypeEnum.END_WITH) {
            return StringUtils.endsWith(input, pattern);
        }
        if (matchType == TextMatcherTypeEnum.NOT_EQUALS) {
            return !StringUtils.equals(input, pattern);
        }
        return false;
    }

    public static boolean regexTextMatches(TextMatcherTypeEnum matchType, Pattern pattern, String input) {
        if (matchType == TextMatcherTypeEnum.REGEX) {
            return StringUtils.regexMatch(input, pattern);
        }
        return false;
    }

    public static boolean numberTextMatches(TextMatcherTypeEnum matchType, String pattern, String input) {
        block10: {
            if (input == null) {
                return false;
            }
            try {
                Double value = Double.valueOf(input);
                Double patternValue = Double.valueOf(pattern);
                if (matchType == TextMatcherTypeEnum.LARGER) {
                    return TextMatcher.compareDoubleValue(patternValue, value) < 0;
                }
                if (matchType == TextMatcherTypeEnum.SMALLER) {
                    return TextMatcher.compareDoubleValue(patternValue, value) > 0;
                }
                if (matchType == TextMatcherTypeEnum.LARGER_EQUALS) {
                    return TextMatcher.compareDoubleValue(patternValue, value) <= 0;
                }
                if (matchType == TextMatcherTypeEnum.SMALLER_EQUALS) {
                    return TextMatcher.compareDoubleValue(patternValue, value) >= 0;
                }
            }
            catch (NumberFormatException e) {
                if (matchType == TextMatcherTypeEnum.LARGER) {
                    return pattern.compareTo(input) < 0;
                }
                if (matchType == TextMatcherTypeEnum.SMALLER) {
                    return pattern.compareTo(input) > 0;
                }
                if (matchType == TextMatcherTypeEnum.LARGER_EQUALS) {
                    return pattern.compareTo(input) <= 0;
                }
                if (matchType != TextMatcherTypeEnum.SMALLER_EQUALS) break block10;
                return pattern.compareTo(input) >= 0;
            }
        }
        return false;
    }

    private static int compareDoubleValue(Double d1, Double d2) {
        if (Math.abs(d1 - d2) > 0.001) {
            if (d1 > d2) {
                return 1;
            }
            return -1;
        }
        return 0;
    }
}

