/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.JsonMarshaler;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class StringUtils {
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean isAnyEmpty(String ... list) {
        for (String str : list) {
            if (!StringUtils.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return str.contains(searchStr);
    }

    public static String substringAfterLast(String str, String separator) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (StringUtils.isEmpty(separator)) {
            return EMPTY;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static boolean isEmptyOrNull(String string) {
        return string == null || string.isEmpty() || "null".equals(string);
    }

    public static boolean startsWith(String string, String prefix) {
        return string != null && (prefix == null || string.startsWith(prefix));
    }

    public static boolean endsWith(String string, String suffix) {
        return string != null && (suffix == null || string.endsWith(suffix));
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        return StringUtils.regionMatches(cs1, false, 0, cs2, 0, cs1.length());
    }

    public static boolean regexMatch(String string, String pattern) {
        if (string == null || pattern == null) {
            return false;
        }
        Pattern regexPattern = Pattern.compile(pattern);
        return StringUtils.regexMatch(string, regexPattern);
    }

    public static boolean regexMatch(String string, Pattern pattern) {
        if (string == null || pattern == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static boolean notEquals(CharSequence cs1, CharSequence cs2) {
        return !StringUtils.equals(cs1, cs2);
    }

    static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        int srcLen = cs.length() - thisStart;
        int otherLen = substring.length() - start;
        if (thisStart < 0 || start < 0 || length < 0) {
            return false;
        }
        if (srcLen < length || otherLen < length) {
            return false;
        }
        while (tmpLen-- > 0) {
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            if (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String text) {
        return !StringUtils.isBlank(text);
    }

    public static String arrayToString(Object[] array) {
        if (array == null) {
            return "null";
        }
        int iMax = array.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(String.valueOf(array[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(",");
            ++i;
        }
    }

    public static String listToString(List<?> list) {
        if (list == null) {
            return "null";
        }
        int iMax = list.size() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(list.get(i).toString());
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(",");
            ++i;
        }
    }

    public static String objectToString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number || object instanceof Character || object instanceof Boolean) {
            return String.valueOf(object);
        }
        JsonMarshaler jsonMarshaler = GlobalInstanceHolder.getInstance(JsonMarshaler.class);
        if (jsonMarshaler == null) {
            throw new RuntimeException("json marshaler is null");
        }
        return jsonMarshaler.writeValueAsString(object);
    }

    public static String objectToStringSafely(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number || object instanceof Character || object instanceof Boolean) {
            return String.valueOf(object);
        }
        JsonMarshaler jsonMarshaler = GlobalInstanceHolder.getInstance(JsonMarshaler.class);
        if (jsonMarshaler == null) {
            throw new RuntimeException("json marshaler is null");
        }
        return jsonMarshaler.writeValueAsStringSafely(object);
    }

    public static String removeStart(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement, -1);
    }

    public static String replaceIgnoreCase(String text, String searchString, String replacement) {
        return StringUtils.replaceIgnoreCase(text, searchString, replacement, -1);
    }

    public static String replaceIgnoreCase(String text, String searchString, String replacement, int max) {
        return StringUtils.replace(text, searchString, replacement, max, true);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        return StringUtils.replace(text, searchString, replacement, max, false);
    }

    public static String replace(String text, String searchString, String replacement, int max, boolean ignoreCase) {
        if (!StringUtils.isEmpty(text) && !StringUtils.isEmpty(searchString) && replacement != null && max != 0) {
            int start;
            int end;
            String searchText = text;
            if (ignoreCase) {
                searchText = text.toLowerCase();
                searchString = searchString.toLowerCase();
            }
            if ((end = searchText.indexOf(searchString, start = 0)) == -1) {
                return text;
            }
            int replLength = searchString.length();
            int increase = replacement.length() - replLength;
            int n = increase = increase < 0 ? 0 : increase;
            StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
            while (end != -1) {
                buf.append(text, start, end).append(replacement);
                start = end + replLength;
                if (--max == 0) break;
                end = searchText.indexOf(searchString, start);
            }
            buf.append(text, start, text.length());
            return buf.toString();
        }
        return text;
    }

    public static boolean isNumeric(String cs) {
        if (StringUtils.isEmpty(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasText(@Nullable String str) {
        return str != null && !str.isEmpty() && StringUtils.containsText(str);
    }

    public static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

