/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanReader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceFlags;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;

public class SpanUtils {
    private static volatile Field traceFlagFieldInSpan;
    private static volatile Field resourceFieldInSpan;
    private static final PatchLogger logger;
    private static final Object dummyObject;
    private static Field dummyField;

    private static boolean skipInvalidSpan(Span span) {
        return !span.isRecording();
    }

    public static <T> T getAttribute(AttributeKey<T> k, Span span) {
        SpanReader spanReader = GlobalInstanceHolder.getInstance(SpanReader.class);
        if (spanReader != null) {
            return spanReader.getAttribute(span, k);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initSampleFlagIfNot(Span span) {
        if (traceFlagFieldInSpan != null) return;
        Class<SpanUtils> clazz = SpanUtils.class;
        synchronized (SpanUtils.class) {
            if (traceFlagFieldInSpan != null) return;
            try {
                traceFlagFieldInSpan = span.getSpanContext().getClass().getDeclaredField("traceFlags");
                traceFlagFieldInSpan.setAccessible(true);
            }
            catch (Throwable t) {
                logger.warning("init sample flag field failed, message=" + t.getMessage());
                traceFlagFieldInSpan = dummyField;
            }
            return;
        }
    }

    public static void updateSampleFlag(Span span, TraceFlags traceFlag) {
        if (SpanUtils.skipInvalidSpan(span)) {
            return;
        }
        SpanUtils.initSampleFlagIfNot(span);
        if (SpanUtils.isValidField(traceFlagFieldInSpan)) {
            try {
                traceFlagFieldInSpan.set(span.getSpanContext(), traceFlag);
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "[SpanUtils]updateSampleFlag failed", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initResourceFieldIfNot(Span span) {
        if (resourceFieldInSpan != null) return;
        Class<SpanUtils> clazz = SpanUtils.class;
        synchronized (SpanUtils.class) {
            if (resourceFieldInSpan != null) return;
            try {
                resourceFieldInSpan = span.getClass().getDeclaredField("resource");
                resourceFieldInSpan.setAccessible(true);
                Field modifiersField = null;
                String jvmVersion = System.getProperty("java.specification.version");
                if (StringUtils.isNullOrEmpty(jvmVersion) || Float.parseFloat(jvmVersion) < 17.0f) {
                    modifiersField = Field.class.getDeclaredField("modifiers");
                } else {
                    Field[] fields;
                    Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
                    getDeclaredFields0.setAccessible(true);
                    for (Field each : fields = (Field[])getDeclaredFields0.invoke(Field.class, false)) {
                        if (!"modifiers".equals(each.getName())) continue;
                        modifiersField = each;
                    }
                }
                if (modifiersField == null) {
                    logger.log(Level.WARNING, "modifiers field not found, BaggageUtil not work");
                } else {
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(resourceFieldInSpan, resourceFieldInSpan.getModifiers() & 0xFFFFFFEF);
                }
            }
            catch (Throwable t) {
                logger.warning("init resource field failed, message=" + t.getMessage());
                resourceFieldInSpan = dummyField;
            }
            return;
        }
    }

    public static void updateResource(Span span, Object newResource) {
        if (SpanUtils.skipInvalidSpan(span)) {
            return;
        }
        SpanUtils.initResourceFieldIfNot(span);
        if (SpanUtils.isValidField(resourceFieldInSpan)) {
            try {
                resourceFieldInSpan.set(span, newResource);
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "[SpanUtils]updateSampleFlag failed", t);
            }
        }
    }

    private static boolean isValidField(Field field) {
        return field != null && field != dummyField;
    }

    static {
        logger = PatchLogger.getLogger(SpanUtils.class.getName());
        dummyObject = new Object();
        try {
            dummyField = SpanUtils.class.getDeclaredField("dummyObject");
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "init dummy field failed", t);
        }
    }
}

