/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class SanitizerUtils {
    private static final String[] REGEX_PARTS = new String[]{"*", "$", "^", "+"};
    public static boolean ARMS_SANITIZER_ENABLE = false;
    public static final String SANITIZED_VALUE = "[******]";
    public static final Set<String> DEFAULT_KEYS_TO_SANITIZE = new LinkedHashSet<String>(Arrays.asList("password", "secret", "key", "token", "credentials"));
    public static Pattern[] keysToSanitize;

    public static Pattern getPattern(String value) {
        if (SanitizerUtils.isRegex(value)) {
            return Pattern.compile(value, 2);
        }
        return Pattern.compile(".*" + value + ".*", 2);
    }

    private static boolean isRegex(String value) {
        for (String part : REGEX_PARTS) {
            if (!value.contains(part)) continue;
            return true;
        }
        return false;
    }

    public static String sanitizerPvs(String pvs, String separator) {
        StringBuilder result = new StringBuilder();
        String[] tags = pvs.split("&");
        for (int i = 0; i < tags.length; ++i) {
            String[] t = tags[i].split(separator);
            String value = "";
            if (t.length == 2) {
                value = (String)SanitizerUtils.sanitize(t[0], t[1]);
                result.append(t[0]).append(separator).append(value);
            } else {
                result.append(tags[i]);
            }
            if (i == tags.length - 1 || result.length() <= 0) continue;
            result.append("&");
        }
        return result.toString();
    }

    public static Object sanitize(String key, Object value) {
        if (value == null) {
            return null;
        }
        if (!ARMS_SANITIZER_ENABLE) {
            return value;
        }
        for (Pattern pattern : keysToSanitize) {
            if (!pattern.matcher(key).matches()) continue;
            return SANITIZED_VALUE;
        }
        return value;
    }
}

