/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.SpanReader;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.GlobalInstanceHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.LocalRootSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsMessageRpcNameState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsScheduledRpcNameState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ArmsUserMethodState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.HttpRouteState;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.RpcMethodState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;

public class RpcUtils {
    private static SpanReader spanReader = GlobalInstanceHolder.getInstance(SpanReader.class);

    public static String getRpc(Context context) {
        SpanKind spanKind;
        Span span = LocalRootSpan.fromContext(context);
        if (span.getSpanContext().isValid() && spanReader != null && ((spanKind = spanReader.readSpanKind(span)) == SpanKind.SERVER || spanKind == SpanKind.CONSUMER)) {
            return spanReader.readSpanName(span);
        }
        HttpRouteState httpRouteState = HttpRouteState.fromContextOrNull(context);
        if (httpRouteState != null && !StringUtils.isNullOrEmpty(httpRouteState.getRoute())) {
            return httpRouteState.getRoute();
        }
        RpcMethodState rpcRouteState = RpcMethodState.fromContextOrNull(context);
        if (rpcRouteState != null && !StringUtils.isNullOrEmpty(rpcRouteState.getMethod())) {
            return rpcRouteState.getMethod();
        }
        ArmsMessageRpcNameState messageRpcNameState = ArmsMessageRpcNameState.fromContextOrNull(context);
        if (messageRpcNameState != null && !StringUtils.isNullOrEmpty(messageRpcNameState.getMessageRpcName())) {
            return messageRpcNameState.getMessageRpcName();
        }
        ArmsScheduledRpcNameState scheduledRpcNameState = ArmsScheduledRpcNameState.fromContextOrNull(context);
        if (scheduledRpcNameState != null && !StringUtils.isNullOrEmpty(scheduledRpcNameState.getScheduledRpcName())) {
            return scheduledRpcNameState.getScheduledRpcName();
        }
        ArmsUserMethodState userMethodState = ArmsUserMethodState.fromContextOrNull(context);
        if (userMethodState != null && !StringUtils.isNullOrEmpty(userMethodState.getUserMethodRpcName())) {
            return userMethodState.getUserMethodRpcName();
        }
        return null;
    }

    static void setSpanReader(SpanReader spanReader) {
        RpcUtils.spanReader = spanReader;
    }
}

