/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.cache.Cache;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class ReflectUtils {
    private static final PatchLogger logger = PatchLogger.getLogger(ReflectUtils.class.getName());
    private static final Cache<String, Boolean> fieldBlacklist = Cache.bounded(100);

    public static Object getSpecifiedFieldFromObject(@Nonnull Object object, String fieldName) {
        String blacklistKey = object.getClass().getName() + "#" + fieldName;
        if (fieldBlacklist.get(blacklistKey) != null) {
            return null;
        }
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            fieldBlacklist.put(blacklistKey, true);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.format("Field '%s' not found in class '%s', added to blacklist", fieldName, object.getClass().getName()));
            }
            return null;
        }
        catch (Throwable t) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, String.format("getSpecifiedFieldFromObject failed to access field, fieldName=%s, clazz=%s", fieldName, object.getClass().getName()), t);
            }
            return null;
        }
    }

    public static <T> Set<T> getSpecifiedFieldFromObject(@Nonnull Object object, @Nonnull Class<T> fieldClass, int recursiveLevel) {
        HashSet results = new HashSet();
        ReflectUtils.doGetSpecifiedFieldFromObject(object, fieldClass, results, recursiveLevel);
        return results;
    }

    private static <T> void doGetSpecifiedFieldFromObject(@Nonnull Object object, @Nonnull Class<T> fieldClass, Set<T> results, int recursiveLevel) {
        ReflectUtils.findFields(object, object.getClass(), fieldClass, results);
        if (recursiveLevel == 0) {
            return;
        }
        HashSet<Object> fields = new HashSet<Object>();
        ReflectUtils.findFieldTypes(object, object.getClass(), fields);
        for (Object e : fields) {
            if (e == null || e.getClass().equals(fieldClass)) continue;
            ReflectUtils.doGetSpecifiedFieldFromObject(e, fieldClass, results, recursiveLevel - 1);
        }
    }

    private static <T> T findFields(@Nonnull Object object, Class<?> clazz, Class<T> fieldType, Set<T> results) {
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!fieldType.equals(field.getType())) continue;
            try {
                field.setAccessible(true);
                results.add(field.get(object));
            }
            catch (Throwable throwable) {
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.log(Level.INFO, String.format("findFields failed, object=%s, clazz=%s, fieldType=%s, currentField=%s", object, clazz, fieldType, field), throwable);
            }
        }
        return ReflectUtils.findFields(object, clazz.getSuperclass(), fieldType, results);
    }

    private static void findFieldTypes(Object object, Class<?> clazz, Set<Object> allNonPrimitiveFields) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            try {
                if (field.getType().isPrimitive() || field.getType().isArray() || Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                allNonPrimitiveFields.add(field.get(object));
            }
            catch (Throwable throwable) {
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.log(Level.INFO, String.format("findFieldTypes failed, object=%s, clazz=%s, currentField=%s", object, clazz, field), throwable);
            }
        }
        ReflectUtils.findFieldTypes(object, clazz.getSuperclass(), allNonPrimitiveFields);
    }
}

