/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MapUtils {
    public static Object getObject(Map map, Object key) {
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public static String getString(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            return answer.toString();
        }
        return null;
    }

    public static Boolean getBoolean(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            if (answer instanceof Boolean) {
                return (Boolean)answer;
            }
            if (answer instanceof String) {
                return new Boolean((String)answer);
            }
            if (answer instanceof Number) {
                Number n = (Number)answer;
                return n.intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    public static Number getNumber(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null) {
            if (answer instanceof Number) {
                return (Number)answer;
            }
            if (answer instanceof String) {
                try {
                    String text = (String)answer;
                    return NumberFormat.getInstance().parse(text);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static Integer getInteger(Map map, Object key) {
        Number answer = MapUtils.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Integer) {
            return (Integer)answer;
        }
        return new Integer(answer.intValue());
    }

    public static Long getLong(Map map, Object key) {
        Number answer = MapUtils.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Long) {
            return (Long)answer;
        }
        return new Long(answer.longValue());
    }

    public static Float getFloat(Map map, Object key) {
        Number answer = MapUtils.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Float) {
            return (Float)answer;
        }
        return new Float(answer.floatValue());
    }

    public static Double getDouble(Map map, Object key) {
        Number answer = MapUtils.getNumber(map, key);
        if (answer == null) {
            return null;
        }
        if (answer instanceof Double) {
            return (Double)answer;
        }
        return new Double(answer.doubleValue());
    }

    public static Map getMap(Map map, Object key) {
        Object answer;
        if (map != null && (answer = map.get(key)) != null && answer instanceof Map) {
            return (Map)answer;
        }
        return null;
    }

    public static <K, V> Map<K, V> of(K k1, V v1) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return Collections.unmodifiableMap(map);
    }
}

