/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class AliyunContextHolderUtils {
    private static final PatchLogger LOGGER = PatchLogger.getLogger(AliyunContextHolderUtils.class.getName());
    public static final ContextKey<Map<String, Object>> ALIYUN_CONTEXT_HOLDER_KEY = ContextKey.named("aliyunContextHolder");
    private static int maxKeyCounts = ConfigPropertiesUtil.getInt("profiler.context.cache-key.max", 10000);

    public static <T> void putToAliyunContext(String key, T value, Context context) {
        Map<String, Object> aliYunContext = context.get(ALIYUN_CONTEXT_HOLDER_KEY);
        if (aliYunContext != null) {
            if (aliYunContext.size() < maxKeyCounts) {
                aliYunContext.put(key, value);
            } else {
                LOGGER.log(Level.INFO, "Aliyun context size exceeds upper limit [" + maxKeyCounts + "]");
            }
        }
    }

    public static <T> T getFromAliyunContext(String key, Context context) {
        Object v;
        Map<String, Object> aliYunContext = context.get(ALIYUN_CONTEXT_HOLDER_KEY);
        if (aliYunContext != null && (v = aliYunContext.get(key)) != null) {
            return (T)v;
        }
        return null;
    }

    public static <T> T removeFromAliyunContext(String key, Context context) {
        Object v;
        Map<String, Object> aliYunContext = context.get(ALIYUN_CONTEXT_HOLDER_KEY);
        if (aliYunContext != null && (v = aliYunContext.remove(key)) != null) {
            return (T)v;
        }
        return null;
    }

    public static Context attachAliyunConyextHolderIfAbsent(Context context) {
        if (context.get(ALIYUN_CONTEXT_HOLDER_KEY) != null) {
            return context;
        }
        return context.with(ALIYUN_CONTEXT_HOLDER_KEY, new LinkedHashMap());
    }
}

