/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.AutoInstanceRegister;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.provider.HasMultipleInstance;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class GlobalInstanceHolder {
    private static final PatchLogger LOGGER = PatchLogger.getLogger(GlobalInstanceHolder.class.getName());
    private static final Map<Class<?>, Object> INSTANCE_HOLDER = new ConcurrentHashMap();
    private static final Map<Class<?>, Set<Object>> INSTANCES_HOLDER = new ConcurrentHashMap();

    public static void registerInstance(Object instance) {
        for (Class<?> clazz : instance.getClass().getInterfaces()) {
            if (clazz.equals(AutoInstanceRegister.class)) continue;
            if (HasMultipleInstance.class.isAssignableFrom(clazz)) {
                INSTANCES_HOLDER.computeIfAbsent(clazz, key -> new HashSet()).add((HasMultipleInstance)instance);
                continue;
            }
            INSTANCE_HOLDER.put(clazz, instance);
        }
    }

    public static <T> T getInstance(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("params clazz is null");
        }
        if (!INSTANCE_HOLDER.containsKey(clazz)) {
            LOGGER.log(Level.WARNING, "Failed to get clazz " + clazz.getName() + " from GlobalInstanceHolder");
            return null;
        }
        return (T)INSTANCE_HOLDER.get(clazz);
    }

    public static <T> Set<T> getInstanceList(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("params clazz is null");
        }
        if (!INSTANCES_HOLDER.containsKey(clazz)) {
            LOGGER.log(Level.WARNING, "Failed to get clazz " + clazz.getName() + " from GlobalInstanceHolder");
            return null;
        }
        return INSTANCES_HOLDER.get(clazz);
    }
}

