/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.memory;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.memory.RamUsageEstimator;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.common.ArmsThreadFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;

public enum ContextTracker {
    INSTANCE;

    static Map<WeakReference<Object>, Long> cleanableMap;
    static final ReferenceQueue<Object> referenceQueue;
    private final AtomicLong instanceCounter = new AtomicLong();
    private final AtomicLong memCounter = new AtomicLong();
    public static final int RPC_THRESHOLD = 1000;
    static final Map<String, Long> contextSizeCache;
    static ExecutorService scheduledExecutorService;

    public long getAliveInstanceCount() {
        return this.instanceCounter.get();
    }

    public long getContextMemBytes() {
        return this.memCounter.get();
    }

    public long incrementAndGet(Object instance, String spanName) {
        Long size;
        if (spanName == null) {
            spanName = "";
        }
        if ((size = contextSizeCache.get(spanName)) == null) {
            if (contextSizeCache.size() < 1000) {
                size = RamUsageEstimator.sizeOf(instance);
                contextSizeCache.put(spanName, size);
            } else {
                long count = this.instanceCounter.get();
                size = count > 0L ? Long.valueOf(this.memCounter.get() / count) : Long.valueOf(0x600000L);
            }
        }
        Long finalSize = size;
        WeakReference<Object> reference = new WeakReference<Object>(instance, referenceQueue);
        cleanableMap.put(reference, finalSize);
        this.memCounter.addAndGet(size);
        return this.instanceCounter.incrementAndGet();
    }

    static {
        cleanableMap = new ConcurrentHashMap<WeakReference<Object>, Long>();
        referenceQueue = new ReferenceQueue();
        contextSizeCache = new ConcurrentHashMap<String, Long>(1000);
        scheduledExecutorService = Executors.newSingleThreadExecutor(new ArmsThreadFactory("arms-context-collector", true));
        scheduledExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Reference<Object> ref;
                            if ((ref = referenceQueue.remove(60000L)) == null) {
                                continue;
                            }
                            long size = cleanableMap.remove(ref);
                            INSTANCE.instanceCounter.decrementAndGet();
                            INSTANCE.memCounter.addAndGet(-size);
                            ref.clear();
                        }
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
        });
    }
}

