/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.RpcIdGeneratorState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.concurrent.atomic.AtomicInteger;

public class RpcIdGenerator {
    private final String currentRpcId;
    private final AtomicInteger counter;
    static final ContextKey<RpcIdGenerator> RPC_ID_GENERATOR_CONTEXT_KEY = ContextKey.named("RPC_ID_GENERATOR_CONTEXT_KEY");
    static final AttributeKey<String> RPC_ID_ATTRIBUTE_KEY = AttributeKey.stringKey("rpc.id");

    public RpcIdGenerator(String currentRpcId) {
        this.currentRpcId = currentRpcId;
        this.counter = new AtomicInteger(0);
    }

    public static Context increaseRpcId4CurrentSpan(Context context) {
        if (!RpcIdGeneratorState.INSTANCE.isEnableRpcId()) {
            return context;
        }
        RpcIdGenerator idGenerator = context.get(RPC_ID_GENERATOR_CONTEXT_KEY);
        if (idGenerator == null) {
            return context.with(RPC_ID_GENERATOR_CONTEXT_KEY, new RpcIdGenerator("0"));
        }
        return context.with(RPC_ID_GENERATOR_CONTEXT_KEY, new RpcIdGenerator(idGenerator.nextRpcId()));
    }

    public static Context restoreRpcIdFromBaggage(Context context) {
        if (!RpcIdGeneratorState.INSTANCE.isEnableRpcId()) {
            return context;
        }
        String rpcId = Baggage.fromContext(context).getEntryValue(RPC_ID_ATTRIBUTE_KEY.getKey());
        if (StringUtils.isNullOrEmpty(rpcId)) {
            return context;
        }
        return context.with(RPC_ID_GENERATOR_CONTEXT_KEY, new RpcIdGenerator(rpcId));
    }

    public static void addRpcIdIntoAttributeIfNeed(AttributesBuilder attributesBuilder, Context context) {
        if (!RpcIdGeneratorState.INSTANCE.isEnableRpcId()) {
            return;
        }
        RpcIdGenerator idGenerator = context.get(RPC_ID_GENERATOR_CONTEXT_KEY);
        if (idGenerator == null) {
            return;
        }
        attributesBuilder.put(RPC_ID_ATTRIBUTE_KEY, idGenerator.currentRpcId);
    }

    public static void addRpcIdIntoBaggageIfNeed(BaggageBuilder baggageBuilder, Context context) {
        if (!RpcIdGeneratorState.INSTANCE.isEnableRpcId()) {
            return;
        }
        RpcIdGenerator idGenerator = context.get(RPC_ID_GENERATOR_CONTEXT_KEY);
        if (idGenerator == null) {
            return;
        }
        baggageBuilder.put(RPC_ID_ATTRIBUTE_KEY.getKey(), idGenerator.currentRpcId);
    }

    public static void enableRpcId() {
        RpcIdGeneratorState.INSTANCE.enableRpcId = true;
    }

    public static void disableRpcId() {
        RpcIdGeneratorState.INSTANCE.enableRpcId = false;
    }

    public String nextRpcId() {
        if ((long)this.currentRpcId.length() >= RpcIdGeneratorState.INSTANCE.maxRpcIdLength) {
            return this.currentRpcId + ".*";
        }
        return this.currentRpcId + "." + this.counter.incrementAndGet();
    }

    public String getCurrentRpcId() {
        return this.currentRpcId;
    }
}

