/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common;

import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.arms.logger.AliyunJavaAgentLoggerFactory;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Optional;
import java.util.regex.Pattern;

public final class NetUtils {
    private static final AliyunJavaAgentLogger logger = AliyunJavaAgentLoggerFactory.getLogger(NetUtils.class.getName());
    public static final String LOCALHOST_VALUE = "127.0.0.1";
    private static volatile InetAddress LOCAL_ADDRESS = null;
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    public static final String ANYHOST_VALUE = "0.0.0.0";

    private NetUtils() {
    }

    public static String getLocalHost() {
        InetAddress address = NetUtils.getLocalAddress();
        return address == null ? LOCALHOST_VALUE : address.getHostAddress();
    }

    public static InetAddress getLocalAddress() {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = NetUtils.getLocalAddress0();
        return localAddress;
    }

    private static InetAddress getLocalAddress0() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            Optional<InetAddress> addressOp = NetUtils.toValidAddress(localAddress);
            if (addressOp.isPresent()) {
                return addressOp.get();
            }
        }
        catch (Throwable e) {
            logger.warn("{}", (Object)e.getMessage(), (Object)e);
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (null == interfaces) {
                return localAddress;
            }
            while (interfaces.hasMoreElements()) {
                try {
                    NetworkInterface network = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = network.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        try {
                            Optional<InetAddress> addressOp = NetUtils.toValidAddress(addresses.nextElement());
                            if (!addressOp.isPresent()) continue;
                            return addressOp.get();
                        }
                        catch (Throwable e) {
                            logger.warn("{}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                }
                catch (Throwable e) {
                    logger.warn("{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        catch (Throwable e) {
            logger.warn("{}", (Object)e.getMessage(), (Object)e);
        }
        return localAddress;
    }

    private static Optional<InetAddress> toValidAddress(InetAddress address) {
        if (NetUtils.isValidPublicAddress(address)) {
            Inet6Address v6Address;
            if (address instanceof Inet6Address && NetUtils.isValidV6Address(v6Address = (Inet6Address)address)) {
                return Optional.ofNullable(NetUtils.normalizeV6Address(v6Address));
            }
            if (NetUtils.isValidV4Address(address)) {
                return Optional.of(address);
            }
        }
        return Optional.empty();
    }

    static boolean isValidPublicAddress(InetAddress address) {
        return !address.isSiteLocalAddress() && !address.isLoopbackAddress();
    }

    static boolean isValidV6Address(Inet6Address address) {
        boolean preferIpv6 = Boolean.getBoolean("java.net.preferIPv6Addresses");
        if (!preferIpv6) {
            return false;
        }
        try {
            return address.isReachable(100);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + '%' + address.getScopeId());
            }
            catch (UnknownHostException e) {
                logger.debug("Unknown IPV6 address: ", e);
            }
        }
        return address;
    }

    static boolean isValidV4Address(InetAddress address) {
        String name = address.getHostAddress();
        return name != null && IP_PATTERN.matcher(name).matches() && !ANYHOST_VALUE.equals(name) && !LOCALHOST_VALUE.equals(name);
    }
}

