/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common;

import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.AgentInfoHolder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.aliyun.common.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class AgentInfo {
    private String hostname;
    private String ip;
    private String ports;
    private String appId;
    private String serviceId;
    private String applicationName;
    private int serviceType;
    private int pid;
    private String regionId = "cn-zhangjiakou";
    private String agentVersion;
    private String vmVersion;
    private long startTimestamp;
    private long endTimestamp;
    private int endStatus;
    private String licenseKey;
    private long timestamp;
    private String agentEnv;
    private String agentArgs = "";
    private String uuId;
    private String processorNum;
    private String memTotalSize;
    private JvmInfo jvmInfo;
    private String appName;
    private String mseUserId;
    private String mseLicenseKey;
    private String mseAppId;
    private String mseNamespace;
    private String mseAppName;
    private String k8sMetadata;
    private String hostMetadata = "";
    private String zoneId = "";
    private String extInfo;
    private String hostEnvTags;
    private String hostVersionTags;
    private String appEnvTags;
    private String appVersionTags;
    private String appClusterIdTag;
    private String appClusterNameTag;
    private String hostNamespaceTag;
    private String hostTags;
    private String appTags;
    private Map<String, String> agentTags;
    private long agentBootstrapStartTimestamp;
    private long agentBootstrapEndTimestamp;
    private String userId;
    private String agentId;
    private String clusterId = "";
    private String clusterName = "";
    private String podAppVersion = "";
    private String podNamespace = "";
    private String podWorkloadName = "";
    private String podWorkloadKind = "";
    private boolean appSecDisable = false;
    private boolean appSecEnable = false;
    private boolean yunDunRaspEnable = false;
    private boolean isFcScenario = false;
    private String acmRegionId;
    private boolean isServerIpSet;
    private String mode;
    private String agentWorkSpace;
    private String cmsWorkspace;
    private String agentTmpDir;
    private String garbageCollectors;
    private AtomicReference<String> agentCustomArgsStr = new AtomicReference<String>("");
    private ConcurrentHashMap<String, String> agentCustomArgs = new ConcurrentHashMap();
    public static final AgentInfo INSTANCE = new AgentInfo();

    private AgentInfo() {
    }

    public void setAppId(String appId) {
        this.appId = appId;
        AgentInfoHolder.armsAppId = appId;
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
        AgentInfoHolder.armsLicenseKey = licenseKey;
    }

    public void setUserId(String userId) {
        this.userId = userId;
        AgentInfoHolder.armsUserId = userId;
    }

    public boolean addAgentCustomArgs(String argKey, String argValue) {
        this.agentCustomArgs.put(argKey, argValue);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.agentCustomArgs.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        return this.agentCustomArgsStr.compareAndSet(this.agentCustomArgsStr.get(), sb.toString());
    }

    public String getMergedArgs() {
        String mergedArgs = this.getAgentArgs();
        if (mergedArgs == null) {
            mergedArgs = "";
        }
        if (StringUtils.isNotEmpty(this.agentCustomArgsStr.get())) {
            mergedArgs = mergedArgs + ";" + this.agentCustomArgsStr.get();
        }
        return mergedArgs;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getIp() {
        return this.ip;
    }

    public String getPorts() {
        return this.ports;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public int getPid() {
        return this.pid;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getVmVersion() {
        return this.vmVersion;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public int getEndStatus() {
        return this.endStatus;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getAgentEnv() {
        return this.agentEnv;
    }

    public String getAgentArgs() {
        return this.agentArgs;
    }

    public String getUuId() {
        return this.uuId;
    }

    public String getProcessorNum() {
        return this.processorNum;
    }

    public String getMemTotalSize() {
        return this.memTotalSize;
    }

    public JvmInfo getJvmInfo() {
        return this.jvmInfo;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getMseUserId() {
        return this.mseUserId;
    }

    public String getMseLicenseKey() {
        return this.mseLicenseKey;
    }

    public String getMseAppId() {
        return this.mseAppId;
    }

    public String getMseNamespace() {
        return this.mseNamespace;
    }

    public String getMseAppName() {
        return this.mseAppName;
    }

    public String getK8sMetadata() {
        return this.k8sMetadata;
    }

    public String getHostMetadata() {
        return this.hostMetadata;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public String getExtInfo() {
        return this.extInfo;
    }

    public String getHostEnvTags() {
        return this.hostEnvTags;
    }

    public String getHostVersionTags() {
        return this.hostVersionTags;
    }

    public String getAppEnvTags() {
        return this.appEnvTags;
    }

    public String getAppVersionTags() {
        return this.appVersionTags;
    }

    public String getAppClusterIdTag() {
        return this.appClusterIdTag;
    }

    public String getAppClusterNameTag() {
        return this.appClusterNameTag;
    }

    public String getHostNamespaceTag() {
        return this.hostNamespaceTag;
    }

    public String getHostTags() {
        return this.hostTags;
    }

    public String getAppTags() {
        return this.appTags;
    }

    public Map<String, String> getAgentTags() {
        return this.agentTags;
    }

    public long getAgentBootstrapStartTimestamp() {
        return this.agentBootstrapStartTimestamp;
    }

    public long getAgentBootstrapEndTimestamp() {
        return this.agentBootstrapEndTimestamp;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getPodAppVersion() {
        return this.podAppVersion;
    }

    public String getPodNamespace() {
        return this.podNamespace;
    }

    public String getPodWorkloadName() {
        return this.podWorkloadName;
    }

    public String getPodWorkloadKind() {
        return this.podWorkloadKind;
    }

    public boolean isAppSecDisable() {
        return this.appSecDisable;
    }

    public boolean isAppSecEnable() {
        return this.appSecEnable;
    }

    public boolean isYunDunRaspEnable() {
        return this.yunDunRaspEnable;
    }

    public boolean isFcScenario() {
        return this.isFcScenario;
    }

    public String getAcmRegionId() {
        return this.acmRegionId;
    }

    public boolean isServerIpSet() {
        return this.isServerIpSet;
    }

    public String getMode() {
        return this.mode;
    }

    public String getAgentWorkSpace() {
        return this.agentWorkSpace;
    }

    public String getCmsWorkspace() {
        return this.cmsWorkspace;
    }

    public String getAgentTmpDir() {
        return this.agentTmpDir;
    }

    public String getGarbageCollectors() {
        return this.garbageCollectors;
    }

    public AtomicReference<String> getAgentCustomArgsStr() {
        return this.agentCustomArgsStr;
    }

    public ConcurrentHashMap<String, String> getAgentCustomArgs() {
        return this.agentCustomArgs;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPorts(String ports) {
        this.ports = ports;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setServiceType(int serviceType) {
        this.serviceType = serviceType;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public void setVmVersion(String vmVersion) {
        this.vmVersion = vmVersion;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public void setEndTimestamp(long endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public void setEndStatus(int endStatus) {
        this.endStatus = endStatus;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setAgentEnv(String agentEnv) {
        this.agentEnv = agentEnv;
    }

    public void setAgentArgs(String agentArgs) {
        this.agentArgs = agentArgs;
    }

    public void setUuId(String uuId) {
        this.uuId = uuId;
    }

    public void setProcessorNum(String processorNum) {
        this.processorNum = processorNum;
    }

    public void setMemTotalSize(String memTotalSize) {
        this.memTotalSize = memTotalSize;
    }

    public void setJvmInfo(JvmInfo jvmInfo) {
        this.jvmInfo = jvmInfo;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setMseUserId(String mseUserId) {
        this.mseUserId = mseUserId;
    }

    public void setMseLicenseKey(String mseLicenseKey) {
        this.mseLicenseKey = mseLicenseKey;
    }

    public void setMseAppId(String mseAppId) {
        this.mseAppId = mseAppId;
    }

    public void setMseNamespace(String mseNamespace) {
        this.mseNamespace = mseNamespace;
    }

    public void setMseAppName(String mseAppName) {
        this.mseAppName = mseAppName;
    }

    public void setK8sMetadata(String k8sMetadata) {
        this.k8sMetadata = k8sMetadata;
    }

    public void setHostMetadata(String hostMetadata) {
        this.hostMetadata = hostMetadata;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    public void setHostEnvTags(String hostEnvTags) {
        this.hostEnvTags = hostEnvTags;
    }

    public void setHostVersionTags(String hostVersionTags) {
        this.hostVersionTags = hostVersionTags;
    }

    public void setAppEnvTags(String appEnvTags) {
        this.appEnvTags = appEnvTags;
    }

    public void setAppVersionTags(String appVersionTags) {
        this.appVersionTags = appVersionTags;
    }

    public void setAppClusterIdTag(String appClusterIdTag) {
        this.appClusterIdTag = appClusterIdTag;
    }

    public void setAppClusterNameTag(String appClusterNameTag) {
        this.appClusterNameTag = appClusterNameTag;
    }

    public void setHostNamespaceTag(String hostNamespaceTag) {
        this.hostNamespaceTag = hostNamespaceTag;
    }

    public void setHostTags(String hostTags) {
        this.hostTags = hostTags;
    }

    public void setAppTags(String appTags) {
        this.appTags = appTags;
    }

    public void setAgentTags(Map<String, String> agentTags) {
        this.agentTags = agentTags;
    }

    public void setAgentBootstrapStartTimestamp(long agentBootstrapStartTimestamp) {
        this.agentBootstrapStartTimestamp = agentBootstrapStartTimestamp;
    }

    public void setAgentBootstrapEndTimestamp(long agentBootstrapEndTimestamp) {
        this.agentBootstrapEndTimestamp = agentBootstrapEndTimestamp;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setPodAppVersion(String podAppVersion) {
        this.podAppVersion = podAppVersion;
    }

    public void setPodNamespace(String podNamespace) {
        this.podNamespace = podNamespace;
    }

    public void setPodWorkloadName(String podWorkloadName) {
        this.podWorkloadName = podWorkloadName;
    }

    public void setPodWorkloadKind(String podWorkloadKind) {
        this.podWorkloadKind = podWorkloadKind;
    }

    public void setAppSecDisable(boolean appSecDisable) {
        this.appSecDisable = appSecDisable;
    }

    public void setAppSecEnable(boolean appSecEnable) {
        this.appSecEnable = appSecEnable;
    }

    public void setYunDunRaspEnable(boolean yunDunRaspEnable) {
        this.yunDunRaspEnable = yunDunRaspEnable;
    }

    public void setFcScenario(boolean isFcScenario) {
        this.isFcScenario = isFcScenario;
    }

    public void setAcmRegionId(String acmRegionId) {
        this.acmRegionId = acmRegionId;
    }

    public void setServerIpSet(boolean isServerIpSet) {
        this.isServerIpSet = isServerIpSet;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setAgentWorkSpace(String agentWorkSpace) {
        this.agentWorkSpace = agentWorkSpace;
    }

    public void setCmsWorkspace(String cmsWorkspace) {
        this.cmsWorkspace = cmsWorkspace;
    }

    public void setAgentTmpDir(String agentTmpDir) {
        this.agentTmpDir = agentTmpDir;
    }

    public void setGarbageCollectors(String garbageCollectors) {
        this.garbageCollectors = garbageCollectors;
    }

    public void setAgentCustomArgsStr(AtomicReference<String> agentCustomArgsStr) {
        this.agentCustomArgsStr = agentCustomArgsStr;
    }

    public void setAgentCustomArgs(ConcurrentHashMap<String, String> agentCustomArgs) {
        this.agentCustomArgs = agentCustomArgs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentInfo)) {
            return false;
        }
        AgentInfo other = (AgentInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getServiceType() != other.getServiceType()) {
            return false;
        }
        if (this.getPid() != other.getPid()) {
            return false;
        }
        if (this.getStartTimestamp() != other.getStartTimestamp()) {
            return false;
        }
        if (this.getEndTimestamp() != other.getEndTimestamp()) {
            return false;
        }
        if (this.getEndStatus() != other.getEndStatus()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getAgentBootstrapStartTimestamp() != other.getAgentBootstrapStartTimestamp()) {
            return false;
        }
        if (this.getAgentBootstrapEndTimestamp() != other.getAgentBootstrapEndTimestamp()) {
            return false;
        }
        if (this.isAppSecDisable() != other.isAppSecDisable()) {
            return false;
        }
        if (this.isAppSecEnable() != other.isAppSecEnable()) {
            return false;
        }
        if (this.isYunDunRaspEnable() != other.isYunDunRaspEnable()) {
            return false;
        }
        if (this.isFcScenario() != other.isFcScenario()) {
            return false;
        }
        if (this.isServerIpSet() != other.isServerIpSet()) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$ports = this.getPorts();
        String other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !this$ports.equals(other$ports)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        String this$regionId = this.getRegionId();
        String other$regionId = other.getRegionId();
        if (this$regionId == null ? other$regionId != null : !this$regionId.equals(other$regionId)) {
            return false;
        }
        String this$agentVersion = this.getAgentVersion();
        String other$agentVersion = other.getAgentVersion();
        if (this$agentVersion == null ? other$agentVersion != null : !this$agentVersion.equals(other$agentVersion)) {
            return false;
        }
        String this$vmVersion = this.getVmVersion();
        String other$vmVersion = other.getVmVersion();
        if (this$vmVersion == null ? other$vmVersion != null : !this$vmVersion.equals(other$vmVersion)) {
            return false;
        }
        String this$licenseKey = this.getLicenseKey();
        String other$licenseKey = other.getLicenseKey();
        if (this$licenseKey == null ? other$licenseKey != null : !this$licenseKey.equals(other$licenseKey)) {
            return false;
        }
        String this$agentEnv = this.getAgentEnv();
        String other$agentEnv = other.getAgentEnv();
        if (this$agentEnv == null ? other$agentEnv != null : !this$agentEnv.equals(other$agentEnv)) {
            return false;
        }
        String this$agentArgs = this.getAgentArgs();
        String other$agentArgs = other.getAgentArgs();
        if (this$agentArgs == null ? other$agentArgs != null : !this$agentArgs.equals(other$agentArgs)) {
            return false;
        }
        String this$uuId = this.getUuId();
        String other$uuId = other.getUuId();
        if (this$uuId == null ? other$uuId != null : !this$uuId.equals(other$uuId)) {
            return false;
        }
        String this$processorNum = this.getProcessorNum();
        String other$processorNum = other.getProcessorNum();
        if (this$processorNum == null ? other$processorNum != null : !this$processorNum.equals(other$processorNum)) {
            return false;
        }
        String this$memTotalSize = this.getMemTotalSize();
        String other$memTotalSize = other.getMemTotalSize();
        if (this$memTotalSize == null ? other$memTotalSize != null : !this$memTotalSize.equals(other$memTotalSize)) {
            return false;
        }
        JvmInfo this$jvmInfo = this.getJvmInfo();
        JvmInfo other$jvmInfo = other.getJvmInfo();
        if (this$jvmInfo == null ? other$jvmInfo != null : !((Object)this$jvmInfo).equals(other$jvmInfo)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$mseUserId = this.getMseUserId();
        String other$mseUserId = other.getMseUserId();
        if (this$mseUserId == null ? other$mseUserId != null : !this$mseUserId.equals(other$mseUserId)) {
            return false;
        }
        String this$mseLicenseKey = this.getMseLicenseKey();
        String other$mseLicenseKey = other.getMseLicenseKey();
        if (this$mseLicenseKey == null ? other$mseLicenseKey != null : !this$mseLicenseKey.equals(other$mseLicenseKey)) {
            return false;
        }
        String this$mseAppId = this.getMseAppId();
        String other$mseAppId = other.getMseAppId();
        if (this$mseAppId == null ? other$mseAppId != null : !this$mseAppId.equals(other$mseAppId)) {
            return false;
        }
        String this$mseNamespace = this.getMseNamespace();
        String other$mseNamespace = other.getMseNamespace();
        if (this$mseNamespace == null ? other$mseNamespace != null : !this$mseNamespace.equals(other$mseNamespace)) {
            return false;
        }
        String this$mseAppName = this.getMseAppName();
        String other$mseAppName = other.getMseAppName();
        if (this$mseAppName == null ? other$mseAppName != null : !this$mseAppName.equals(other$mseAppName)) {
            return false;
        }
        String this$k8sMetadata = this.getK8sMetadata();
        String other$k8sMetadata = other.getK8sMetadata();
        if (this$k8sMetadata == null ? other$k8sMetadata != null : !this$k8sMetadata.equals(other$k8sMetadata)) {
            return false;
        }
        String this$hostMetadata = this.getHostMetadata();
        String other$hostMetadata = other.getHostMetadata();
        if (this$hostMetadata == null ? other$hostMetadata != null : !this$hostMetadata.equals(other$hostMetadata)) {
            return false;
        }
        String this$zoneId = this.getZoneId();
        String other$zoneId = other.getZoneId();
        if (this$zoneId == null ? other$zoneId != null : !this$zoneId.equals(other$zoneId)) {
            return false;
        }
        String this$extInfo = this.getExtInfo();
        String other$extInfo = other.getExtInfo();
        if (this$extInfo == null ? other$extInfo != null : !this$extInfo.equals(other$extInfo)) {
            return false;
        }
        String this$hostEnvTags = this.getHostEnvTags();
        String other$hostEnvTags = other.getHostEnvTags();
        if (this$hostEnvTags == null ? other$hostEnvTags != null : !this$hostEnvTags.equals(other$hostEnvTags)) {
            return false;
        }
        String this$hostVersionTags = this.getHostVersionTags();
        String other$hostVersionTags = other.getHostVersionTags();
        if (this$hostVersionTags == null ? other$hostVersionTags != null : !this$hostVersionTags.equals(other$hostVersionTags)) {
            return false;
        }
        String this$appEnvTags = this.getAppEnvTags();
        String other$appEnvTags = other.getAppEnvTags();
        if (this$appEnvTags == null ? other$appEnvTags != null : !this$appEnvTags.equals(other$appEnvTags)) {
            return false;
        }
        String this$appVersionTags = this.getAppVersionTags();
        String other$appVersionTags = other.getAppVersionTags();
        if (this$appVersionTags == null ? other$appVersionTags != null : !this$appVersionTags.equals(other$appVersionTags)) {
            return false;
        }
        String this$appClusterIdTag = this.getAppClusterIdTag();
        String other$appClusterIdTag = other.getAppClusterIdTag();
        if (this$appClusterIdTag == null ? other$appClusterIdTag != null : !this$appClusterIdTag.equals(other$appClusterIdTag)) {
            return false;
        }
        String this$appClusterNameTag = this.getAppClusterNameTag();
        String other$appClusterNameTag = other.getAppClusterNameTag();
        if (this$appClusterNameTag == null ? other$appClusterNameTag != null : !this$appClusterNameTag.equals(other$appClusterNameTag)) {
            return false;
        }
        String this$hostNamespaceTag = this.getHostNamespaceTag();
        String other$hostNamespaceTag = other.getHostNamespaceTag();
        if (this$hostNamespaceTag == null ? other$hostNamespaceTag != null : !this$hostNamespaceTag.equals(other$hostNamespaceTag)) {
            return false;
        }
        String this$hostTags = this.getHostTags();
        String other$hostTags = other.getHostTags();
        if (this$hostTags == null ? other$hostTags != null : !this$hostTags.equals(other$hostTags)) {
            return false;
        }
        String this$appTags = this.getAppTags();
        String other$appTags = other.getAppTags();
        if (this$appTags == null ? other$appTags != null : !this$appTags.equals(other$appTags)) {
            return false;
        }
        Map<String, String> this$agentTags = this.getAgentTags();
        Map<String, String> other$agentTags = other.getAgentTags();
        if (this$agentTags == null ? other$agentTags != null : !((Object)this$agentTags).equals(other$agentTags)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        String this$clusterId = this.getClusterId();
        String other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$podAppVersion = this.getPodAppVersion();
        String other$podAppVersion = other.getPodAppVersion();
        if (this$podAppVersion == null ? other$podAppVersion != null : !this$podAppVersion.equals(other$podAppVersion)) {
            return false;
        }
        String this$podNamespace = this.getPodNamespace();
        String other$podNamespace = other.getPodNamespace();
        if (this$podNamespace == null ? other$podNamespace != null : !this$podNamespace.equals(other$podNamespace)) {
            return false;
        }
        String this$podWorkloadName = this.getPodWorkloadName();
        String other$podWorkloadName = other.getPodWorkloadName();
        if (this$podWorkloadName == null ? other$podWorkloadName != null : !this$podWorkloadName.equals(other$podWorkloadName)) {
            return false;
        }
        String this$podWorkloadKind = this.getPodWorkloadKind();
        String other$podWorkloadKind = other.getPodWorkloadKind();
        if (this$podWorkloadKind == null ? other$podWorkloadKind != null : !this$podWorkloadKind.equals(other$podWorkloadKind)) {
            return false;
        }
        String this$acmRegionId = this.getAcmRegionId();
        String other$acmRegionId = other.getAcmRegionId();
        if (this$acmRegionId == null ? other$acmRegionId != null : !this$acmRegionId.equals(other$acmRegionId)) {
            return false;
        }
        String this$mode = this.getMode();
        String other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        String this$agentWorkSpace = this.getAgentWorkSpace();
        String other$agentWorkSpace = other.getAgentWorkSpace();
        if (this$agentWorkSpace == null ? other$agentWorkSpace != null : !this$agentWorkSpace.equals(other$agentWorkSpace)) {
            return false;
        }
        String this$cmsWorkspace = this.getCmsWorkspace();
        String other$cmsWorkspace = other.getCmsWorkspace();
        if (this$cmsWorkspace == null ? other$cmsWorkspace != null : !this$cmsWorkspace.equals(other$cmsWorkspace)) {
            return false;
        }
        String this$agentTmpDir = this.getAgentTmpDir();
        String other$agentTmpDir = other.getAgentTmpDir();
        if (this$agentTmpDir == null ? other$agentTmpDir != null : !this$agentTmpDir.equals(other$agentTmpDir)) {
            return false;
        }
        String this$garbageCollectors = this.getGarbageCollectors();
        String other$garbageCollectors = other.getGarbageCollectors();
        if (this$garbageCollectors == null ? other$garbageCollectors != null : !this$garbageCollectors.equals(other$garbageCollectors)) {
            return false;
        }
        AtomicReference<String> this$agentCustomArgsStr = this.getAgentCustomArgsStr();
        AtomicReference<String> other$agentCustomArgsStr = other.getAgentCustomArgsStr();
        if (this$agentCustomArgsStr == null ? other$agentCustomArgsStr != null : !this$agentCustomArgsStr.equals(other$agentCustomArgsStr)) {
            return false;
        }
        ConcurrentHashMap<String, String> this$agentCustomArgs = this.getAgentCustomArgs();
        ConcurrentHashMap<String, String> other$agentCustomArgs = other.getAgentCustomArgs();
        return !(this$agentCustomArgs == null ? other$agentCustomArgs != null : !((Object)this$agentCustomArgs).equals(other$agentCustomArgs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgentInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getServiceType();
        result = result * 59 + this.getPid();
        long $startTimestamp = this.getStartTimestamp();
        result = result * 59 + (int)($startTimestamp >>> 32 ^ $startTimestamp);
        long $endTimestamp = this.getEndTimestamp();
        result = result * 59 + (int)($endTimestamp >>> 32 ^ $endTimestamp);
        result = result * 59 + this.getEndStatus();
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $agentBootstrapStartTimestamp = this.getAgentBootstrapStartTimestamp();
        result = result * 59 + (int)($agentBootstrapStartTimestamp >>> 32 ^ $agentBootstrapStartTimestamp);
        long $agentBootstrapEndTimestamp = this.getAgentBootstrapEndTimestamp();
        result = result * 59 + (int)($agentBootstrapEndTimestamp >>> 32 ^ $agentBootstrapEndTimestamp);
        result = result * 59 + (this.isAppSecDisable() ? 79 : 97);
        result = result * 59 + (this.isAppSecEnable() ? 79 : 97);
        result = result * 59 + (this.isYunDunRaspEnable() ? 79 : 97);
        result = result * 59 + (this.isFcScenario() ? 79 : 97);
        result = result * 59 + (this.isServerIpSet() ? 79 : 97);
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : $ports.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        String $regionId = this.getRegionId();
        result = result * 59 + ($regionId == null ? 43 : $regionId.hashCode());
        String $agentVersion = this.getAgentVersion();
        result = result * 59 + ($agentVersion == null ? 43 : $agentVersion.hashCode());
        String $vmVersion = this.getVmVersion();
        result = result * 59 + ($vmVersion == null ? 43 : $vmVersion.hashCode());
        String $licenseKey = this.getLicenseKey();
        result = result * 59 + ($licenseKey == null ? 43 : $licenseKey.hashCode());
        String $agentEnv = this.getAgentEnv();
        result = result * 59 + ($agentEnv == null ? 43 : $agentEnv.hashCode());
        String $agentArgs = this.getAgentArgs();
        result = result * 59 + ($agentArgs == null ? 43 : $agentArgs.hashCode());
        String $uuId = this.getUuId();
        result = result * 59 + ($uuId == null ? 43 : $uuId.hashCode());
        String $processorNum = this.getProcessorNum();
        result = result * 59 + ($processorNum == null ? 43 : $processorNum.hashCode());
        String $memTotalSize = this.getMemTotalSize();
        result = result * 59 + ($memTotalSize == null ? 43 : $memTotalSize.hashCode());
        JvmInfo $jvmInfo = this.getJvmInfo();
        result = result * 59 + ($jvmInfo == null ? 43 : ((Object)$jvmInfo).hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $mseUserId = this.getMseUserId();
        result = result * 59 + ($mseUserId == null ? 43 : $mseUserId.hashCode());
        String $mseLicenseKey = this.getMseLicenseKey();
        result = result * 59 + ($mseLicenseKey == null ? 43 : $mseLicenseKey.hashCode());
        String $mseAppId = this.getMseAppId();
        result = result * 59 + ($mseAppId == null ? 43 : $mseAppId.hashCode());
        String $mseNamespace = this.getMseNamespace();
        result = result * 59 + ($mseNamespace == null ? 43 : $mseNamespace.hashCode());
        String $mseAppName = this.getMseAppName();
        result = result * 59 + ($mseAppName == null ? 43 : $mseAppName.hashCode());
        String $k8sMetadata = this.getK8sMetadata();
        result = result * 59 + ($k8sMetadata == null ? 43 : $k8sMetadata.hashCode());
        String $hostMetadata = this.getHostMetadata();
        result = result * 59 + ($hostMetadata == null ? 43 : $hostMetadata.hashCode());
        String $zoneId = this.getZoneId();
        result = result * 59 + ($zoneId == null ? 43 : $zoneId.hashCode());
        String $extInfo = this.getExtInfo();
        result = result * 59 + ($extInfo == null ? 43 : $extInfo.hashCode());
        String $hostEnvTags = this.getHostEnvTags();
        result = result * 59 + ($hostEnvTags == null ? 43 : $hostEnvTags.hashCode());
        String $hostVersionTags = this.getHostVersionTags();
        result = result * 59 + ($hostVersionTags == null ? 43 : $hostVersionTags.hashCode());
        String $appEnvTags = this.getAppEnvTags();
        result = result * 59 + ($appEnvTags == null ? 43 : $appEnvTags.hashCode());
        String $appVersionTags = this.getAppVersionTags();
        result = result * 59 + ($appVersionTags == null ? 43 : $appVersionTags.hashCode());
        String $appClusterIdTag = this.getAppClusterIdTag();
        result = result * 59 + ($appClusterIdTag == null ? 43 : $appClusterIdTag.hashCode());
        String $appClusterNameTag = this.getAppClusterNameTag();
        result = result * 59 + ($appClusterNameTag == null ? 43 : $appClusterNameTag.hashCode());
        String $hostNamespaceTag = this.getHostNamespaceTag();
        result = result * 59 + ($hostNamespaceTag == null ? 43 : $hostNamespaceTag.hashCode());
        String $hostTags = this.getHostTags();
        result = result * 59 + ($hostTags == null ? 43 : $hostTags.hashCode());
        String $appTags = this.getAppTags();
        result = result * 59 + ($appTags == null ? 43 : $appTags.hashCode());
        Map<String, String> $agentTags = this.getAgentTags();
        result = result * 59 + ($agentTags == null ? 43 : ((Object)$agentTags).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        String $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $podAppVersion = this.getPodAppVersion();
        result = result * 59 + ($podAppVersion == null ? 43 : $podAppVersion.hashCode());
        String $podNamespace = this.getPodNamespace();
        result = result * 59 + ($podNamespace == null ? 43 : $podNamespace.hashCode());
        String $podWorkloadName = this.getPodWorkloadName();
        result = result * 59 + ($podWorkloadName == null ? 43 : $podWorkloadName.hashCode());
        String $podWorkloadKind = this.getPodWorkloadKind();
        result = result * 59 + ($podWorkloadKind == null ? 43 : $podWorkloadKind.hashCode());
        String $acmRegionId = this.getAcmRegionId();
        result = result * 59 + ($acmRegionId == null ? 43 : $acmRegionId.hashCode());
        String $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        String $agentWorkSpace = this.getAgentWorkSpace();
        result = result * 59 + ($agentWorkSpace == null ? 43 : $agentWorkSpace.hashCode());
        String $cmsWorkspace = this.getCmsWorkspace();
        result = result * 59 + ($cmsWorkspace == null ? 43 : $cmsWorkspace.hashCode());
        String $agentTmpDir = this.getAgentTmpDir();
        result = result * 59 + ($agentTmpDir == null ? 43 : $agentTmpDir.hashCode());
        String $garbageCollectors = this.getGarbageCollectors();
        result = result * 59 + ($garbageCollectors == null ? 43 : $garbageCollectors.hashCode());
        AtomicReference<String> $agentCustomArgsStr = this.getAgentCustomArgsStr();
        result = result * 59 + ($agentCustomArgsStr == null ? 43 : $agentCustomArgsStr.hashCode());
        ConcurrentHashMap<String, String> $agentCustomArgs = this.getAgentCustomArgs();
        result = result * 59 + ($agentCustomArgs == null ? 43 : ((Object)$agentCustomArgs).hashCode());
        return result;
    }

    public String toString() {
        return "AgentInfo(hostname=" + this.getHostname() + ", ip=" + this.getIp() + ", ports=" + this.getPorts() + ", appId=" + this.getAppId() + ", serviceId=" + this.getServiceId() + ", applicationName=" + this.getApplicationName() + ", serviceType=" + this.getServiceType() + ", pid=" + this.getPid() + ", regionId=" + this.getRegionId() + ", agentVersion=" + this.getAgentVersion() + ", vmVersion=" + this.getVmVersion() + ", startTimestamp=" + this.getStartTimestamp() + ", endTimestamp=" + this.getEndTimestamp() + ", endStatus=" + this.getEndStatus() + ", licenseKey=" + this.getLicenseKey() + ", timestamp=" + this.getTimestamp() + ", agentEnv=" + this.getAgentEnv() + ", agentArgs=" + this.getAgentArgs() + ", uuId=" + this.getUuId() + ", processorNum=" + this.getProcessorNum() + ", memTotalSize=" + this.getMemTotalSize() + ", jvmInfo=" + this.getJvmInfo() + ", appName=" + this.getAppName() + ", mseUserId=" + this.getMseUserId() + ", mseLicenseKey=" + this.getMseLicenseKey() + ", mseAppId=" + this.getMseAppId() + ", mseNamespace=" + this.getMseNamespace() + ", mseAppName=" + this.getMseAppName() + ", k8sMetadata=" + this.getK8sMetadata() + ", hostMetadata=" + this.getHostMetadata() + ", zoneId=" + this.getZoneId() + ", extInfo=" + this.getExtInfo() + ", hostEnvTags=" + this.getHostEnvTags() + ", hostVersionTags=" + this.getHostVersionTags() + ", appEnvTags=" + this.getAppEnvTags() + ", appVersionTags=" + this.getAppVersionTags() + ", appClusterIdTag=" + this.getAppClusterIdTag() + ", appClusterNameTag=" + this.getAppClusterNameTag() + ", hostNamespaceTag=" + this.getHostNamespaceTag() + ", hostTags=" + this.getHostTags() + ", appTags=" + this.getAppTags() + ", agentTags=" + this.getAgentTags() + ", agentBootstrapStartTimestamp=" + this.getAgentBootstrapStartTimestamp() + ", agentBootstrapEndTimestamp=" + this.getAgentBootstrapEndTimestamp() + ", userId=" + this.getUserId() + ", agentId=" + this.getAgentId() + ", clusterId=" + this.getClusterId() + ", clusterName=" + this.getClusterName() + ", podAppVersion=" + this.getPodAppVersion() + ", podNamespace=" + this.getPodNamespace() + ", podWorkloadName=" + this.getPodWorkloadName() + ", podWorkloadKind=" + this.getPodWorkloadKind() + ", appSecDisable=" + this.isAppSecDisable() + ", appSecEnable=" + this.isAppSecEnable() + ", yunDunRaspEnable=" + this.isYunDunRaspEnable() + ", isFcScenario=" + this.isFcScenario() + ", acmRegionId=" + this.getAcmRegionId() + ", isServerIpSet=" + this.isServerIpSet() + ", mode=" + this.getMode() + ", agentWorkSpace=" + this.getAgentWorkSpace() + ", cmsWorkspace=" + this.getCmsWorkspace() + ", agentTmpDir=" + this.getAgentTmpDir() + ", garbageCollectors=" + this.getGarbageCollectors() + ", agentCustomArgsStr=" + this.getAgentCustomArgsStr() + ", agentCustomArgs=" + this.getAgentCustomArgs() + ")";
    }

    public static class JvmInfo {
        private short version;
        private String vmVersion;
        private String vendor;
        private String jvmType;
        private List<String> vmArgs;

        public short getVersion() {
            return this.version;
        }

        public String getVmVersion() {
            return this.vmVersion;
        }

        public String getVendor() {
            return this.vendor;
        }

        public String getJvmType() {
            return this.jvmType;
        }

        public List<String> getVmArgs() {
            return this.vmArgs;
        }

        public void setVersion(short version) {
            this.version = version;
        }

        public void setVmVersion(String vmVersion) {
            this.vmVersion = vmVersion;
        }

        public void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public void setJvmType(String jvmType) {
            this.jvmType = jvmType;
        }

        public void setVmArgs(List<String> vmArgs) {
            this.vmArgs = vmArgs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JvmInfo)) {
                return false;
            }
            JvmInfo other = (JvmInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            String this$vmVersion = this.getVmVersion();
            String other$vmVersion = other.getVmVersion();
            if (this$vmVersion == null ? other$vmVersion != null : !this$vmVersion.equals(other$vmVersion)) {
                return false;
            }
            String this$vendor = this.getVendor();
            String other$vendor = other.getVendor();
            if (this$vendor == null ? other$vendor != null : !this$vendor.equals(other$vendor)) {
                return false;
            }
            String this$jvmType = this.getJvmType();
            String other$jvmType = other.getJvmType();
            if (this$jvmType == null ? other$jvmType != null : !this$jvmType.equals(other$jvmType)) {
                return false;
            }
            List<String> this$vmArgs = this.getVmArgs();
            List<String> other$vmArgs = other.getVmArgs();
            return !(this$vmArgs == null ? other$vmArgs != null : !((Object)this$vmArgs).equals(other$vmArgs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JvmInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getVersion();
            String $vmVersion = this.getVmVersion();
            result = result * 59 + ($vmVersion == null ? 43 : $vmVersion.hashCode());
            String $vendor = this.getVendor();
            result = result * 59 + ($vendor == null ? 43 : $vendor.hashCode());
            String $jvmType = this.getJvmType();
            result = result * 59 + ($jvmType == null ? 43 : $jvmType.hashCode());
            List<String> $vmArgs = this.getVmArgs();
            result = result * 59 + ($vmArgs == null ? 43 : ((Object)$vmArgs).hashCode());
            return result;
        }

        public String toString() {
            return "AgentInfo.JvmInfo(version=" + this.getVersion() + ", vmVersion=" + this.getVmVersion() + ", vendor=" + this.getVendor() + ", jvmType=" + this.getJvmType() + ", vmArgs=" + this.getVmArgs() + ")";
        }
    }
}

