/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.com.alibaba.arms.metrics.spec;

import java.util.Arrays;

public enum UniCallKind {
    UNKNOWN("unknown"),
    CUSTOM_ENTRY("custom_entry"),
    HTTP("http"),
    HTTP_CLIENT("http_client"),
    RPC("rpc"),
    RPC_CLIENT("rpc_client"),
    SQL("sql"),
    NO_SQL("nosql"),
    CACHE("cache"),
    PRODUCER("producer"),
    CONSUMER("consumer"),
    SCHEDULE("schedule"),
    CLIENT("client"),
    SERVER("server"),
    SPAN("span"),
    INTERNAL("internal"),
    DB("db");

    private String name;

    private UniCallKind(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static boolean isDB(UniCallKind kind) {
        return DB.equals((Object)kind) || SQL.equals((Object)kind) || NO_SQL.equals((Object)kind) || CACHE.equals((Object)kind);
    }

    public static UniCallKind findByName(String name) {
        return Arrays.stream(UniCallKind.values()).filter(e -> e.getName().equalsIgnoreCase(name)).findFirst().orElse(UNKNOWN);
    }
}

