/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.com.alibaba.arms.metrics.spec;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public enum EnumStore {
    CORE_STORE("metricstore-apm-metrics", Integer.MAX_VALUE),
    DETAIL_STORE("metricstore-apm-metrics-detail", 0x7FFFFFFE),
    CUSTOM_STORE("metricstore-apm-metrics-custom", 0x7FFFFFFD);

    private static List<EnumStore> SORTED_BY_PRIORITY;
    private final String store;
    private final int priority;

    private EnumStore(String store, int priority) {
        this.store = store;
        this.priority = priority;
    }

    public static List<EnumStore> getSortedStore() {
        return SORTED_BY_PRIORITY;
    }

    public String getStore() {
        return this.store;
    }

    static {
        SORTED_BY_PRIORITY = Arrays.asList(EnumStore.values());
        SORTED_BY_PRIORITY.sort(new Comparator<EnumStore>(){

            @Override
            public int compare(EnumStore o1, EnumStore o2) {
                return Integer.compare(o2.priority, o1.priority);
            }
        });
    }
}

