/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.com.alibaba.arms.metrics.spec;

import java.util.Arrays;

public enum EnumAppType {
    RETCODE("RETCODE", ""),
    RUM("RUM", "rum"),
    TRACE_ALL("TRACE_ALL", ""),
    TRACE("TRACE", "apm"),
    XTRACE("XTRACE", "xtrace"),
    EAGLEEYE("EAGLEEYE", ""),
    EBPF("EBPF", "ebpf"),
    UNKNOWN("UNKNOWN", "unknown");

    private String code;
    private String source;

    private EnumAppType(String code, String source) {
        this.code = code;
        this.source = source;
    }

    public String getCode() {
        return this.code;
    }

    public static EnumAppType parseByCode(String code) {
        if ("apm".equalsIgnoreCase(code)) {
            return TRACE;
        }
        return Arrays.stream(EnumAppType.values()).filter(e -> e.getCode().equalsIgnoreCase(code)).findFirst().orElse(UNKNOWN);
    }

    public static EnumAppType getAppTypeByCode(String code) {
        for (EnumAppType each : EnumAppType.values()) {
            if (!each.code.equalsIgnoreCase(code)) continue;
            return each;
        }
        throw new IllegalArgumentException("\u65e0\u6548\u7684appType[" + code + "]");
    }

    public static EnumAppType getAppTypeBySource(String sourceCode) {
        for (EnumAppType each : EnumAppType.values()) {
            if (!each.source.equalsIgnoreCase(sourceCode)) continue;
            return each;
        }
        throw new IllegalArgumentException("\u65e0\u6548\u7684sourceCode[" + sourceCode + "]");
    }

    public static EnumAppType getAppTypeByCodeSliently(String code) {
        return EnumAppType.parseByCode(code);
    }

    public String getSource() {
        return this.source;
    }
}

