/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.whitelist;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SimplePropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.whitelist.WhiteListConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.whitelist.WhiteListConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WhiteListConfigManager {
    private static volatile Map<String, WhiteListConfig> whiteListMap = new HashMap<String, WhiteListConfig>();
    private static SentinelProperty<List<WhiteListConfig>> currentProperty = new DynamicSentinelProperty<List<WhiteListConfig>>();
    private static final WhiteListPropertyListener LISTENER = new WhiteListPropertyListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<WhiteListConfig>> property) {
        AssertUtil.notNull(property, "property cannot be null");
        WhiteListPropertyListener whiteListPropertyListener = LISTENER;
        synchronized (whiteListPropertyListener) {
            RecordLog.info("[WhiteListConfigManager] Registering new property to WhiteListConfigManager", new Object[0]);
            currentProperty.removeListener(LISTENER);
            property.addListener(LISTENER);
            currentProperty = property;
        }
    }

    public static List<WhiteListConfig> getConfigs() {
        ArrayList<WhiteListConfig> whiteListConfigs = new ArrayList<WhiteListConfig>();
        for (Map.Entry<String, WhiteListConfig> entry : whiteListMap.entrySet()) {
            whiteListConfigs.add(entry.getValue());
        }
        return whiteListConfigs;
    }

    public static void loadConfig(List<WhiteListConfig> configList) {
        currentProperty.updateValue(configList);
    }

    static Map<String, WhiteListConfig> getWhiteListMap() {
        return whiteListMap;
    }

    public static WhiteListConfig getWhiteList(String moduleName) {
        return whiteListMap.get(moduleName);
    }

    static {
        currentProperty.addListener(LISTENER);
    }

    private static final class WhiteListPropertyListener
    extends SimplePropertyListener<List<WhiteListConfig>> {
        private WhiteListPropertyListener() {
        }

        @Override
        public void configUpdate(List<WhiteListConfig> value) {
            Map<String, WhiteListConfig> newWhiteListMap = this.buildWhiteListMap(value);
            whiteListMap = newWhiteListMap;
            RecordLog.info("[WhiteListConfigManager] WhiteListConfigs received: " + newWhiteListMap, new Object[0]);
        }

        private Map<String, WhiteListConfig> buildWhiteListMap(List<WhiteListConfig> configList) {
            HashMap<String, WhiteListConfig> whiteListConfigMap = new HashMap<String, WhiteListConfig>();
            if (configList == null || configList.isEmpty()) {
                return whiteListConfigMap;
            }
            for (WhiteListConfig config : configList) {
                if (!this.isValidConfig(config)) {
                    RecordLog.warn("[WhiteListConfigManager] Ignoring invalid WhiteListConfig when loading new flow rules: " + config, new Object[0]);
                    continue;
                }
                whiteListConfigMap.put(config.moduleName, config);
            }
            return whiteListConfigMap;
        }

        private boolean isValidConfig(WhiteListConfig config) {
            if (config == null) {
                return false;
            }
            return !StringUtil.isBlank(config.getModuleName()) && WhiteListConstants.WHITE_LIST_MODULE.contains(config.getModuleName());
        }
    }
}

