/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.slot;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.context.Context;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.DefaultNode;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.AbstractLinkedProcessorSlot;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.BlockException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowChecker;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetricStorage;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.rule.WebFlowException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.rule.WebFlowRuleManager;
import java.util.List;
import java.util.Map;

public class WebFlowSlot
extends AbstractLinkedProcessorSlot<DefaultNode> {
    private static final String EMPTY_PARAM = "";

    @Override
    public void entry(Context context, ResourceWrapper resource, DefaultNode node, int count, boolean prioritized, Object ... args) throws Throwable {
        if (!WebFlowRuleManager.hasRules(resource.getName())) {
            this.fireEntry(context, resource, node, count, prioritized, args);
            return;
        }
        this.checkWebFlow(resource, count, context.getCurEntry().getArgMap());
        this.fireEntry(context, resource, node, count, prioritized, args);
    }

    private void checkWebFlow(ResourceWrapper resourceWrapper, int count, Map<String, Object> argMap) throws BlockException {
        if (argMap == null) {
            return;
        }
        List<ParamFlowRule> rules = WebFlowRuleManager.getConvertedParamRules(resourceWrapper.getName());
        if (rules == null || rules.isEmpty()) {
            return;
        }
        for (ParamFlowRule rule : rules) {
            ParameterMetricStorage.initParamMetricsFor(resourceWrapper, rule);
            if (ParamFlowChecker.passCheck(resourceWrapper, rule, count, argMap)) continue;
            Object value = argMap.get(rule.getParamKey());
            String triggeredParam = value == null ? EMPTY_PARAM : value.toString();
            throw new WebFlowException(resourceWrapper.getName(), triggeredParam, rule);
        }
    }

    @Override
    public void exit(Context context, ResourceWrapper resourceWrapper, int count, Object ... args) {
        this.fireExit(context, resourceWrapper, count, args);
    }
}

