/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.rule;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.PropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetric;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetricStorage;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.param.ParamRegexCache;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.rule.WebFlowRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.rule.WebFlowRuleConverter;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.rule.WebParamItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class WebFlowRuleManager {
    private static final Map<String, Set<WebFlowRule>> WEB_FLOW_RULE_MAP = new ConcurrentHashMap<String, Set<WebFlowRule>>();
    private static final Map<String, List<ParamFlowRule>> CONVERTED_WEB_FLOW_RULE_MAP = new ConcurrentHashMap<String, List<ParamFlowRule>>();
    private static final WebFlowRulePropertyListener LISTENER = new WebFlowRulePropertyListener();
    private static final Set<Integer> FIELD_REQUIRED_SET = new HashSet<Integer>(Arrays.asList(3, 2, 4, 5, 6));
    private static SentinelProperty<Set<WebFlowRule>> currentProperty = new DynamicSentinelProperty<Set<WebFlowRule>>();

    private WebFlowRuleManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<Set<WebFlowRule>> property) {
        AssertUtil.notNull(property, "property cannot be null");
        WebFlowRulePropertyListener webFlowRulePropertyListener = LISTENER;
        synchronized (webFlowRulePropertyListener) {
            RecordLog.info("[WebFlowRuleManager] Registering new property to web flow rule manager", new Object[0]);
            currentProperty.removeListener(LISTENER);
            property.addListener(LISTENER);
            currentProperty = property;
        }
    }

    public static boolean loadRules(Set<WebFlowRule> rules) {
        return currentProperty.updateValue(rules);
    }

    public static Set<WebFlowRule> getRules() {
        HashSet<WebFlowRule> rules = new HashSet<WebFlowRule>();
        for (Set<WebFlowRule> ruleSet : WEB_FLOW_RULE_MAP.values()) {
            rules.addAll(ruleSet);
        }
        return rules;
    }

    public static Set<WebFlowRule> getRulesForResource(String resourceName) {
        if (StringUtil.isBlank(resourceName)) {
            return new HashSet<WebFlowRule>();
        }
        Set<WebFlowRule> set = WEB_FLOW_RULE_MAP.get(resourceName);
        if (set == null) {
            return new HashSet<WebFlowRule>();
        }
        return new HashSet<WebFlowRule>(set);
    }

    public static List<ParamFlowRule> getConvertedParamRules(String resourceName) {
        if (StringUtil.isBlank(resourceName)) {
            return new ArrayList<ParamFlowRule>();
        }
        return CONVERTED_WEB_FLOW_RULE_MAP.get(resourceName);
    }

    public static boolean hasRules(String resourceName) {
        List<ParamFlowRule> rules = CONVERTED_WEB_FLOW_RULE_MAP.get(resourceName);
        return rules != null && !rules.isEmpty();
    }

    public static boolean isValidRule(WebFlowRule rule) {
        if (rule == null || StringUtil.isBlank(rule.getResource()) || rule.getResourceMode() < 0 || rule.getControlBehavior() < 0) {
            return false;
        }
        if (rule.getCount() == null || rule.getCount() < 0.0) {
            return false;
        }
        if (rule.getControlBehavior() == 2 && rule.getMaxQueueingTimeoutMs() < 0) {
            return false;
        }
        if (rule.getIntervalMs() <= 0L) {
            return false;
        }
        WebParamItem item = rule.getParamItem();
        if (item != null) {
            return WebFlowRuleManager.isValidParamItem(item);
        }
        return true;
    }

    static boolean isValidParamItem(WebParamItem item) {
        if (item.getParseStrategy() < 0) {
            return false;
        }
        if (FIELD_REQUIRED_SET.contains(item.getParseStrategy()) && StringUtil.isBlank(item.getFieldName())) {
            return false;
        }
        return StringUtil.isEmpty(item.getPattern()) || item.getMatchStrategy() >= 0;
    }

    static {
        currentProperty.addListener(LISTENER);
    }

    private static final class WebFlowRulePropertyListener
    implements PropertyListener<Set<WebFlowRule>> {
        private WebFlowRulePropertyListener() {
        }

        @Override
        public void configUpdate(Set<WebFlowRule> conf) {
            this.applyWebFlowRuleInternal(conf);
            RecordLog.info("[WebFlowRuleManager] Web flow rules received: " + WEB_FLOW_RULE_MAP, new Object[0]);
        }

        @Override
        public void configLoad(Set<WebFlowRule> conf) {
            this.applyWebFlowRuleInternal(conf);
            RecordLog.info("[WebFlowRuleManager] Web flow rules loaded: " + WEB_FLOW_RULE_MAP, new Object[0]);
        }

        private void cacheRegexPattern(WebParamItem item) {
            String pattern = item.getPattern();
            if (StringUtil.isNotEmpty(pattern) && item.getMatchStrategy() == 2 && ParamRegexCache.getRegexPattern(pattern) == null) {
                ParamRegexCache.addRegexPattern(pattern);
            }
        }

        private synchronized void applyWebFlowRuleInternal(Set<WebFlowRule> conf) {
            if (conf == null || conf.isEmpty()) {
                this.applyToConvertedParamMap(new HashSet<ParamFlowRule>());
                WEB_FLOW_RULE_MAP.clear();
                return;
            }
            ConcurrentHashMap<String, HashSet<WebFlowRule>> webFlowRuleMap = new ConcurrentHashMap<String, HashSet<WebFlowRule>>();
            HashMap idxMap = new HashMap();
            HashSet<ParamFlowRule> paramFlowRules = new HashSet<ParamFlowRule>();
            HashMap<String, ArrayList<WebFlowRule>> noParamMap = new HashMap<String, ArrayList<WebFlowRule>>();
            for (WebFlowRule webFlowRule : conf) {
                if (!WebFlowRuleManager.isValidRule(webFlowRule)) {
                    RecordLog.warn("[WebFlowRuleManager] Ignoring invalid rule when loading new rules: " + webFlowRule, new Object[0]);
                    continue;
                }
                String resourceName = webFlowRule.getResource();
                if (webFlowRule.getParamItem() == null) {
                    ArrayList<WebFlowRule> noParamList = (ArrayList<WebFlowRule>)noParamMap.get(resourceName);
                    if (noParamList == null) {
                        noParamList = new ArrayList<WebFlowRule>();
                        noParamMap.put(resourceName, noParamList);
                    }
                    noParamList.add(webFlowRule);
                } else {
                    paramFlowRules.add(WebFlowRuleConverter.applyToParamRule(webFlowRule));
                    this.cacheRegexPattern(webFlowRule.getParamItem());
                }
                HashSet<WebFlowRule> ruleSet = (HashSet<WebFlowRule>)webFlowRuleMap.get(resourceName);
                if (ruleSet == null) {
                    ruleSet = new HashSet<WebFlowRule>();
                    webFlowRuleMap.put(resourceName, ruleSet);
                }
                ruleSet.add(webFlowRule);
            }
            for (Map.Entry entry : noParamMap.entrySet()) {
                List rules = (List)entry.getValue();
                if (rules == null || rules.isEmpty()) continue;
                for (WebFlowRule rule : rules) {
                    paramFlowRules.add(WebFlowRuleConverter.applyNonParamToParamRule(rule));
                }
            }
            this.applyToConvertedParamMap(paramFlowRules);
            WEB_FLOW_RULE_MAP.clear();
            WEB_FLOW_RULE_MAP.putAll(webFlowRuleMap);
        }

        private void applyToConvertedParamMap(Set<ParamFlowRule> paramFlowRules) {
            Map<String, List<ParamFlowRule>> newRuleMap = ParamFlowRuleUtil.buildParamRuleMap(new ArrayList<ParamFlowRule>(paramFlowRules));
            if (newRuleMap == null || newRuleMap.isEmpty()) {
                for (String resource : CONVERTED_WEB_FLOW_RULE_MAP.keySet()) {
                    ParameterMetricStorage.clearParamMetricForResource(resource);
                }
                RecordLog.info("[WebFlowRuleManager] No web param rules, clearing parameter metrics of previous rules", new Object[0]);
                CONVERTED_WEB_FLOW_RULE_MAP.clear();
                return;
            }
            for (Map.Entry entry : CONVERTED_WEB_FLOW_RULE_MAP.entrySet()) {
                String resource = (String)entry.getKey();
                if (!newRuleMap.containsKey(resource)) {
                    ParameterMetricStorage.clearParamMetricForResource(resource);
                    continue;
                }
                List<ParamFlowRule> newRuleList = newRuleMap.get(resource);
                ArrayList oldRuleList = new ArrayList((Collection)entry.getValue());
                oldRuleList.removeAll(newRuleList);
                for (ParamFlowRule rule : oldRuleList) {
                    ParameterMetric metric = ParameterMetricStorage.getParamMetricForResource(resource);
                    if (null == metric) continue;
                    metric.clearForRule(rule);
                }
            }
            CONVERTED_WEB_FLOW_RULE_MAP.clear();
            CONVERTED_WEB_FLOW_RULE_MAP.putAll(newRuleMap);
            RecordLog.info("[WebFlowRuleManager] Converted internal param rules: " + CONVERTED_WEB_FLOW_RULE_MAP, new Object[0]);
        }
    }
}

