/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.rule;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowItem;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.SentinelWebFlowConstants;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.rule.WebFlowRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.rule.WebParamItem;

public final class WebFlowRuleConverter {
    public static final String WEB_PARAM_RULE_KEY_PREFIX = "$WEB_PF";

    static FlowRule toFlowRule(WebFlowRule rule) {
        return new FlowRule(rule.getResource()).setControlBehavior(rule.getControlBehavior()).setCount(rule.getCount()).setGrade(rule.getGrade()).setMaxQueueingTimeMs(rule.getMaxQueueingTimeoutMs());
    }

    static ParamFlowItem generateNonMatchPassParamItem() {
        return new ParamFlowItem().setClassType(String.class.getName()).setCount(1.0E7).setObject("$NM");
    }

    static ParamFlowItem generateNonMatchBlockParamItem() {
        return new ParamFlowItem().setClassType(String.class.getName()).setCount(0.0).setObject("$NM");
    }

    static ParamFlowRule applyNonParamToParamRule(WebFlowRule webFlowRule) {
        return new ParamFlowRule(webFlowRule.getResource(), webFlowRule.getId()).setCount(webFlowRule.getCount()).setGrade(webFlowRule.getGrade()).setDurationInSec(webFlowRule.getIntervalMs() / 1000L).setBurstCount(webFlowRule.getBurst()).setControlBehavior(webFlowRule.getControlBehavior()).setMaxQueueingTimeMs(webFlowRule.getMaxQueueingTimeoutMs()).setParamKey("DEFAULT_KEY");
    }

    static ParamFlowRule applyToParamRule(WebFlowRule webFlowRule) {
        ParamFlowRule paramRule = new ParamFlowRule(webFlowRule.getResource(), webFlowRule.getId()).setCount(webFlowRule.getCount()).setGrade(webFlowRule.getGrade()).setDurationInSec(webFlowRule.getIntervalMs() / 1000L).setBurstCount(webFlowRule.getBurst()).setControlBehavior(webFlowRule.getControlBehavior()).setMaxQueueingTimeMs(webFlowRule.getMaxQueueingTimeoutMs());
        WebParamItem webParamItem = webFlowRule.getParamItem();
        String convertedParamKey = WebFlowRuleConverter.generateParamKeyForWebRule(webFlowRule);
        paramRule.setParamKey(convertedParamKey);
        webParamItem.setConvertedParamKey(convertedParamKey);
        String valuePattern = webParamItem.getPattern();
        if (valuePattern != null) {
            paramRule.getParamFlowItemList().add(WebFlowRuleConverter.generateNonMatchPassParamItem());
        }
        if (webFlowRule.isClusterMode()) {
            paramRule.setClusterConfig(webFlowRule.getClusterConfig());
        }
        return paramRule;
    }

    public static String generateParamKeyForWebRule(WebFlowRule rule) {
        if (rule == null || rule.getId() == null) {
            return null;
        }
        WebParamItem item = rule.getParamItem();
        if (item == null) {
            return "$WEB_PF|" + rule.getId();
        }
        String paramKey = SentinelWebFlowConstants.PARSE_STRATEGY_KEY_MAP.get(item.getParseStrategy());
        if (paramKey == null) {
            paramKey = "UNKNOWN";
        }
        return "$WEB_PF|" + paramKey + '|' + rule.getId();
    }

    public static String getCachedConvertedParamKey(WebParamItem item) {
        if (item == null) {
            return null;
        }
        return item.getConvertedParamKey();
    }

    private WebFlowRuleConverter() {
    }
}

