/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.route;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Predicate;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.route.WebPrefixRoutePathMatcher;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.route.WebRegexRoutePathMatcher;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.route.WebServletUtils;
import javax.servlet.http.HttpServletRequest;

public final class WebRouteMatchers {
    public static Predicate<HttpServletRequest> all() {
        return new Predicate<HttpServletRequest>(){

            @Override
            public boolean test(HttpServletRequest requestContext) {
                return true;
            }
        };
    }

    public static Predicate<HttpServletRequest> antPath(String pathPattern) {
        return new WebPrefixRoutePathMatcher(pathPattern);
    }

    public static Predicate<HttpServletRequest> exactPath(final String path) {
        return new Predicate<HttpServletRequest>(){

            @Override
            public boolean test(HttpServletRequest request) {
                return WebServletUtils.getPath(request).equals(path);
            }
        };
    }

    public static Predicate<HttpServletRequest> regexPath(String pathPattern) {
        return new WebRegexRoutePathMatcher(pathPattern);
    }

    private WebRouteMatchers() {
    }
}

