/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.route;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Predicate;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.route.WebServletUtils;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class WebRegexRoutePathMatcher
implements Predicate<HttpServletRequest> {
    private final String pattern;
    private final Pattern regex;

    public WebRegexRoutePathMatcher(String pattern) {
        AssertUtil.assertNotBlank(pattern, "pattern cannot be blank");
        this.pattern = pattern;
        this.regex = Pattern.compile(pattern);
    }

    @Override
    public boolean test(HttpServletRequest request) {
        String path = WebServletUtils.getPath(request);
        return this.regex.matcher(path).matches();
    }

    public String getPattern() {
        return this.pattern;
    }
}

