/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.param;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Predicate;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.param.ParamRegexCache;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.param.RequestItemParser;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.rule.WebFlowRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.rule.WebFlowRuleConverter;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.rule.WebFlowRuleManager;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.rule.WebParamItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;

public class WebParamParser<T> {
    private static final String UNKNOWN = "unknown";
    private static final String SEPARATOR = ",";
    private static final String HEADER_X_FORWARDED_FOR = "X-Forwarded-For";
    private static final String HEADER_PROXY_CLIENT_IP = "Proxy-Client-IP";
    private static final String HEADER_WL_PROXY_CLIENT_IP = "WL-Proxy-Client-IP";
    private static final String HEADER_X_REAL_IP = "X-Real-IP";
    private static final String HEADER_HTTP_CLIENT_IP = "HTTP_CLIENT_IP";
    private final RequestItemParser<T> requestItemParser;

    public WebParamParser(RequestItemParser<T> requestItemParser) {
        AssertUtil.notNull(requestItemParser, "requestItemParser cannot be null");
        this.requestItemParser = requestItemParser;
    }

    public Map<String, Object> parseParameterFor(String resource, T request, Predicate<WebFlowRule> rulePredicate) {
        if (StringUtil.isEmpty(resource) || request == null) {
            return new HashMap<String, Object>();
        }
        HashSet<WebFlowRule> webFlowRules = new HashSet<WebFlowRule>();
        HashSet<Boolean> predSet = new HashSet<Boolean>();
        boolean hasNonParamRule = false;
        for (WebFlowRule rule : WebFlowRuleManager.getRulesForResource(resource)) {
            if (rule.getParamItem() != null) {
                webFlowRules.add(rule);
                predSet.add(rulePredicate == null || rulePredicate.test(rule));
                continue;
            }
            hasNonParamRule = true;
        }
        if (!hasNonParamRule && webFlowRules.isEmpty()) {
            return new HashMap<String, Object>();
        }
        if (predSet.size() > 1 || predSet.contains(false)) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        for (WebFlowRule rule : webFlowRules) {
            WebParamItem paramItem = rule.getParamItem();
            if (paramItem == null) continue;
            String paramValue = this.parseInternal(paramItem, request);
            String paramKey = WebFlowRuleConverter.getCachedConvertedParamKey(paramItem);
            argMap.put(paramKey, paramValue);
        }
        if (hasNonParamRule) {
            argMap.put("default", "DEFAULT_KEY");
        }
        return argMap;
    }

    public String parseInternal(WebParamItem item, T request) {
        switch (item.getParseStrategy()) {
            case 0: {
                return this.parseClientIp(item, request);
            }
            case 1: {
                return this.parseHost(item, request);
            }
            case 2: {
                return this.parseHeader(item, request);
            }
            case 3: {
                return this.parseUrlParameter(item, request);
            }
            case 4: {
                return this.parseCookie(item, request);
            }
            case 5: {
                return this.parseBody(item, request);
            }
            case 6: {
                return this.parsePath(item, request);
            }
        }
        return null;
    }

    public String parsePath(WebParamItem item, T request) {
        String pathName = item.getFieldName();
        String pattern = item.getPattern();
        String param = this.requestItemParser.getPathValue(request, pathName);
        if (StringUtil.isEmpty(pattern)) {
            return param;
        }
        return WebParamParser.parseWithMatchStrategyInternal(item.getMatchStrategy(), param, pattern);
    }

    public String parseClientIp(WebParamItem item, T request) {
        String pattern;
        String ipAddress = this.requestItemParser.getHeader(request, HEADER_X_FORWARDED_FOR);
        if (StringUtil.isBlank(ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = this.requestItemParser.getHeader(request, HEADER_PROXY_CLIENT_IP);
        }
        if (StringUtil.isBlank(ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = this.requestItemParser.getHeader(request, HEADER_PROXY_CLIENT_IP);
        }
        if (StringUtil.isBlank(ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = this.requestItemParser.getHeader(request, HEADER_WL_PROXY_CLIENT_IP);
        }
        if (StringUtil.isBlank(ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = this.requestItemParser.getHeader(request, HEADER_X_REAL_IP);
        }
        if (StringUtil.isBlank(ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = this.requestItemParser.getHeader(request, HEADER_HTTP_CLIENT_IP);
        }
        if (StringUtil.isBlank(ipAddress) || UNKNOWN.equalsIgnoreCase(ipAddress)) {
            ipAddress = this.requestItemParser.getRemoteAddress(request);
        }
        if (!StringUtil.isEmpty(ipAddress) && ipAddress.contains(SEPARATOR)) {
            ipAddress = ipAddress.split(SEPARATOR)[0].trim();
        }
        if (StringUtil.isEmpty(pattern = item.getPattern())) {
            return ipAddress;
        }
        return WebParamParser.parseWithMatchStrategyInternal(item.getMatchStrategy(), ipAddress, pattern);
    }

    public String parseHeader(WebParamItem item, T request) {
        String headerKey = item.getFieldName();
        String pattern = item.getPattern();
        String headerValue = this.requestItemParser.getHeader(request, headerKey);
        if (StringUtil.isEmpty(pattern)) {
            return headerValue;
        }
        return WebParamParser.parseWithMatchStrategyInternal(item.getMatchStrategy(), headerValue, pattern);
    }

    public String parseHost(WebParamItem item, T request) {
        String pattern = item.getPattern();
        String host = this.requestItemParser.getHeader(request, "Host");
        if (StringUtil.isEmpty(pattern)) {
            return host;
        }
        return WebParamParser.parseWithMatchStrategyInternal(item.getMatchStrategy(), host, pattern);
    }

    public String parseUrlParameter(WebParamItem item, T request) {
        String paramName = item.getFieldName();
        String pattern = item.getPattern();
        String param = this.requestItemParser.getUrlParam(request, paramName);
        if (StringUtil.isEmpty(pattern)) {
            return param;
        }
        return WebParamParser.parseWithMatchStrategyInternal(item.getMatchStrategy(), param, pattern);
    }

    public String parseCookie(WebParamItem item, T request) {
        String cookieName = item.getFieldName();
        String pattern = item.getPattern();
        String param = this.requestItemParser.getCookieValue(request, cookieName);
        if (StringUtil.isEmpty(pattern)) {
            return param;
        }
        return WebParamParser.parseWithMatchStrategyInternal(item.getMatchStrategy(), param, pattern);
    }

    public String parseBody(WebParamItem item, T request) {
        String bodyName = item.getFieldName();
        String pattern = item.getPattern();
        String param = this.requestItemParser.getBodyValue(request, bodyName);
        if (StringUtil.isEmpty(pattern)) {
            return param;
        }
        return WebParamParser.parseWithMatchStrategyInternal(item.getMatchStrategy(), param, pattern);
    }

    static String parseWithMatchStrategyInternal(Integer matchStrategy, String value, String pattern) {
        if (value == null || matchStrategy == null) {
            return null;
        }
        switch (matchStrategy) {
            case 0: {
                return value.equals(pattern) ? value : "$NM";
            }
            case 3: {
                return value.contains(pattern) ? value : "$NM";
            }
            case 2: {
                Pattern regex = ParamRegexCache.getRegexPattern(pattern);
                if (regex == null) {
                    return value;
                }
                return regex.matcher(value).matches() ? value : "$NM";
            }
        }
        return value;
    }
}

