/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.api;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.api.ApiDefinition;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.api.WebParamApiMatcher;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

public final class WebParamApiMatcherManager {
    private static final Map<String, WebParamApiMatcher> API_MATCHER_MAP = new ConcurrentHashMap<String, WebParamApiMatcher>();

    public static Map<String, WebParamApiMatcher> getApiMatcherMap() {
        return Collections.unmodifiableMap(API_MATCHER_MAP);
    }

    public static WebParamApiMatcher getMatcher(String apiName) {
        if (apiName == null) {
            return null;
        }
        return API_MATCHER_MAP.get(apiName);
    }

    public static Set<ApiDefinition> getApiDefinitionSet() {
        HashSet<ApiDefinition> set = new HashSet<ApiDefinition>();
        for (WebParamApiMatcher matcher : API_MATCHER_MAP.values()) {
            set.add(matcher.getApiDefinition());
        }
        return set;
    }

    static synchronized void loadApiDefinitions(Set<ApiDefinition> definitions) {
        if (definitions == null || definitions.isEmpty()) {
            API_MATCHER_MAP.clear();
            return;
        }
        for (ApiDefinition definition : definitions) {
            WebParamApiMatcherManager.addApiDefinition(definition);
        }
    }

    static void addApiDefinition(ApiDefinition definition) {
        API_MATCHER_MAP.put(definition.getApiName(), new WebParamApiMatcher(definition));
    }

    public static Set<String> pickMatchingApiDefinitions(HttpServletRequest request) {
        HashSet<String> apis = new HashSet<String>();
        for (WebParamApiMatcher matcher : WebParamApiMatcherManager.getApiMatcherMap().values()) {
            if (!matcher.test(request)) continue;
            apis.add(matcher.getApiName());
        }
        return apis;
    }

    private WebParamApiMatcherManager() {
    }
}

