/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.api;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Predicate;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.api.AbstractCommonApiMatcher;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.api.ApiDefinition;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.api.ApiPredicateItem;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.api.WebApiPathPredicateItem;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.webflow.route.WebRouteMatchers;
import javax.servlet.http.HttpServletRequest;

public class WebParamApiMatcher
extends AbstractCommonApiMatcher<HttpServletRequest> {
    public WebParamApiMatcher(ApiDefinition apiDefinition) {
        super(apiDefinition);
    }

    @Override
    protected void initializeMatchers() {
        if (this.apiDefinition.getPredicateItems() != null) {
            for (ApiPredicateItem item : this.apiDefinition.getPredicateItems()) {
                Predicate<HttpServletRequest> predicate = this.fromApiPredicate(item);
                if (predicate == null) continue;
                this.matchers.add(predicate);
            }
        }
    }

    private Predicate<HttpServletRequest> fromApiPredicate(ApiPredicateItem item) {
        if (item instanceof WebApiPathPredicateItem) {
            return this.fromApiPathPredicate((WebApiPathPredicateItem)item);
        }
        return null;
    }

    private Predicate<HttpServletRequest> fromApiPathPredicate(WebApiPathPredicateItem item) {
        String pattern = item.getPattern();
        if (StringUtil.isBlank(pattern)) {
            return null;
        }
        try {
            switch (item.getMatchStrategy()) {
                case 2: {
                    return WebRouteMatchers.regexPath(pattern);
                }
                case 1: {
                    return WebRouteMatchers.antPath(pattern);
                }
            }
            return WebRouteMatchers.exactPath(pattern);
        }
        catch (Exception ex) {
            RecordLog.error("Failed to create route matcher for API group pattern: " + item.toString(), ex);
            return null;
        }
    }
}

