/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;

public final class VersionUtil {
    private static final boolean jdk8OrHigher = VersionUtil.isJdkNOrHigher(1.8);
    private static final boolean jdk7OrHigher = VersionUtil.isJdkNOrHigher(1.7);

    public static String getVersion(String defaultVersion) {
        try {
            String version = VersionUtil.class.getPackage().getImplementationVersion();
            return StringUtil.isBlank(version) ? defaultVersion : version;
        }
        catch (Throwable e) {
            RecordLog.warn("Using default version, ignore exception", e);
            return defaultVersion;
        }
    }

    private static boolean isJdkNOrHigher(double ver) {
        try {
            int i;
            int tokenSize;
            String[] strings;
            String version = System.getProperty("java.version");
            if (version == null || version.isEmpty()) {
                version = System.getProperty("java.specification.version");
            }
            if ((strings = (version = version.replaceAll("_", ".")).split("\\.")).length > (tokenSize = 2)) {
                version = strings[0] + "." + strings[1];
            }
            return (i = Double.compare(Double.parseDouble(version), ver)) >= 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isJdk8OrHigher() {
        return jdk8OrHigher;
    }

    public static boolean isJdk7OrHigher() {
        return jdk7OrHigher;
    }

    private VersionUtil() {
    }
}

